/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.move.handlers;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.lang.ElementsHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCRefactoringBundle;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.refactoring.move.ui.OCAbstractMoveDialog;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCMoveTopLevelRefactoringHandler
implements RefactoringActionHandler,
ElementsHandler {
    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        Editor editor = dataContext != null ? (Editor)CommonDataKeys.EDITOR.getData(dataContext) : null;
        Set set = ContainerUtil.set((Object[])elements);
        this.showDialog(elements[0], (Condition<PsiElement>)((Condition)element -> set.contains(element)), editor);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("refactoring.moveTopLevel");
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        int offset = editor.getCaretModel().getOffset();
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement element = file.findElementAt(offset);
        if (element == null || !CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)element)) {
            return;
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.hasSelection()) {
            TextRange selectionRange = new TextRange(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd());
            this.showDialog(element, (Condition<PsiElement>)((Condition)element12 -> element12 != null && file.equals(element12.getContainingFile()) && selectionRange.contains(element12.getTextRange())), editor);
        } else {
            this.showDialog(element, (Condition<PsiElement>)((Condition)element1 -> element1 != null && file.equals(element1.getContainingFile()) && element1.getTextRange().containsOffset(offset)), editor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showDialog(PsiElement element, Condition<PsiElement> selectedCond, Editor editor) {
        OCAbstractMoveDialog dialog;
        Project project = element.getProject();
        if (!OCSearchScope.isInProjectSources(element)) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RefactoringBundle.message((String)"error.out.of.project.element.default"), (String)this.getTitle(), null);
            return;
        }
        PsiNamedElement parent = (PsiNamedElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{OCCppNamespace.class, OCFile.class});
        OCAbstractMoveDialog oCAbstractMoveDialog = dialog = parent instanceof OCCppNamespace ? this.createDialog((OCCppNamespace)parent, selectedCond) : this.createDialog((OCFile)parent, selectedCond);
        if (dialog == null) {
            return;
        }
        try {
            if (!dialog.allowsEmptySelection() && dialog.getMemberInfos().isEmpty()) {
                String cannotRefactorMessage = parent instanceof OCCppNamespace ? OCRefactoringBundle.message("refactoring.move.namespace.has.no.members", parent.getName()) : OCRefactoringBundle.message("refactoring.move.file.has.no.members", parent.getName());
                String message = RefactoringBundle.getCannotRefactorMessage((String)cannotRefactorMessage);
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)this.getTitle(), null);
                return;
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                try {
                    dialog.checkCanRun();
                }
                catch (ConfigurationException e) {
                    this.passToTest(e.getMessage(), new OCFile[0]);
                    if (!dialog.isDisposed()) {
                        Disposer.dispose((Disposable)dialog.getDisposable());
                    }
                    return;
                }
                Pair<OCFile[], String> pair = dialog.invokeRefactoring();
                this.passToTest((String)pair.getSecond(), (OCFile[])pair.getFirst());
                return;
            }
            dialog.show();
        }
        finally {
            if (!dialog.isDisposed()) {
                Disposer.dispose((Disposable)dialog.getDisposable());
            }
        }
    }

    protected void passToTest(String conflicts, OCFile[] newFiles) {
    }

    public boolean isEnabledOnElements(PsiElement[] elements) {
        return true;
    }

    @Nls
    protected abstract String getTitle();

    @Nullable
    protected abstract OCAbstractMoveDialog createDialog(OCFile var1, Condition<PsiElement> var2);

    @Nullable
    protected abstract OCAbstractMoveDialog createDialog(OCCppNamespace var1, Condition<PsiElement> var2);
}

