/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.move;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.symbols.ComplexTextRange;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCodeMoveValidator
extends OCRecursiveVisitor {
    private PsiElement myTargetContext;
    private String myOutOfScopeMessage;

    public OCCodeMoveValidator(PsiElement targetContext) {
        this.myTargetContext = targetContext;
    }

    public boolean isOutOfScope() {
        return this.myOutOfScopeMessage != null;
    }

    public String getOutOfScopeMessage() {
        return this.myOutOfScopeMessage;
    }

    @Override
    public void visitReferenceExpression(OCReferenceExpression expression) {
        super.visitReferenceExpression(expression);
        OCElementTypes.SelfSuperToken token = expression.getSelfSuperToken();
        OCResolveContext context = OCResolveContext.forPsi(expression);
        if (token != null) {
            if (this.myTargetContext == null) {
                this.myOutOfScopeMessage = "Using self/super";
                return;
            }
            OCMethod sourceMethod = (OCMethod)PsiTreeUtil.getParentOfType((PsiElement)expression, OCMethod.class);
            OCMethod targetMethod = (OCMethod)PsiTreeUtil.getParentOfType((PsiElement)this.myTargetContext, OCMethod.class);
            OCClassDeclaration sourceClass = (OCClassDeclaration)PsiTreeUtil.getParentOfType((PsiElement)sourceMethod, OCClassDeclaration.class);
            OCClassDeclaration targetClass = (OCClassDeclaration)PsiTreeUtil.getParentOfType((PsiElement)this.myTargetContext, OCClassDeclaration.class);
            if (sourceMethod == null || targetMethod == null || sourceMethod.isInstanceMethod() != targetMethod.isInstanceMethod()) {
                this.myOutOfScopeMessage = "using \"" + StringUtil.toLowerCase((String)token.name()) + "\" from " + (sourceMethod != null && sourceMethod.isInstanceMethod() ? "instance" : "class") + " method";
            } else if (sourceClass == null || targetClass == null || !Objects.equals(sourceClass.getName(), targetClass.getName())) {
                this.myOutOfScopeMessage = "using \"" + StringUtil.toLowerCase((String)token.name()) + "\" from another class";
            }
        } else if (expression.isCppThis()) {
            OCSymbolWithQualifiedName targetOwner;
            OCFunctionDefinition sourceFun = (OCFunctionDefinition)PsiTreeUtil.getContextOfType((PsiElement)expression, (boolean)false, (Class[])new Class[]{OCFunctionDefinition.class});
            OCFunctionDefinition targetFun = (OCFunctionDefinition)PsiTreeUtil.getContextOfType((PsiElement)this.myTargetContext, (boolean)false, (Class[])new Class[]{OCFunctionDefinition.class});
            OCFunctionSymbol sourceFunSymbol = sourceFun != null ? sourceFun.getSymbol() : null;
            OCFunctionSymbol targetFunSymbol = targetFun != null ? targetFun.getSymbol() : null;
            OCSymbolWithQualifiedName sourceOwner = sourceFunSymbol != null ? sourceFunSymbol.getResolvedOwner(context) : null;
            OCSymbolWithQualifiedName oCSymbolWithQualifiedName = targetOwner = targetFunSymbol != null ? targetFunSymbol.getResolvedOwner(context) : null;
            if (sourceOwner != null && !sourceOwner.equals(targetOwner)) {
                this.myOutOfScopeMessage = "using \"this\" from another class";
            }
        } else {
            OCSymbol symbol = expression.resolveToSymbol();
            if (symbol != null && !OCCodeMoveValidator.isInScope(symbol, this.myTargetContext, expression.getProject())) {
                this.myOutOfScopeMessage = "using " + symbol.getNameWithKindLowercase(context) + " which is out of scope";
            }
        }
    }

    public static boolean isInScope(OCSymbol symbol, PsiElement context, @NotNull Project project) {
        if (symbol instanceof OCInstanceVariableSymbol) {
            return OCCodeMoveValidator.isInAncestorClass(((OCInstanceVariableSymbol)symbol).getParent(), context);
        }
        if (symbol instanceof OCDeclaratorSymbol && !symbol.isGlobal() && context != null) {
            ComplexTextRange scope = symbol.getScope();
            VirtualFile contextFile = context.getContainingFile().getVirtualFile();
            return scope != null && Comparing.equal((Object)contextFile, (Object)symbol.getContainingFile()) && scope.contains(OCSymbolOffsetUtil.getComplexOffset(context));
        }
        if (symbol instanceof OCSymbolWithQualifiedName) {
            OCResolveContext resolveContext = OCResolveContext.forNullablePsi(context, project);
            OCSymbolWithQualifiedName owner = ((OCSymbolWithQualifiedName)symbol).getResolvedOwner(resolveContext);
            return owner == null || OCCodeMoveValidator.isInAncestorClass(owner, context, resolveContext);
        }
        return true;
    }

    public static boolean isInAncestorClass(OCClassSymbol clazz, PsiElement context) {
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)context, (Class[])new Class[]{OCMethod.class, OCSynthesizeProperty.class});
        if (parent == null || parent instanceof OCMethod && !((OCMethod)parent).isInstanceMethod()) {
            return false;
        }
        Project project = parent.getProject();
        OCClassSymbol contextClass = (parent = PsiTreeUtil.getParentOfType((PsiElement)parent, OCClassDeclaration.class)) != null ? ((OCClassDeclaration)parent).getSymbol() : null;
        return contextClass != null && contextClass.isSubclass(clazz, project);
    }

    public static boolean isInAncestorClass(OCSymbolWithQualifiedName container, @Nullable PsiElement psiContext, @NotNull OCResolveContext context) {
        OCSymbolWithQualifiedName owner;
        OCFunctionDefinition function = (OCFunctionDefinition)PsiTreeUtil.getParentOfType((PsiElement)psiContext, OCFunctionDefinition.class);
        OCFunctionSymbol functionSymbol = function != null ? function.getSymbol() : null;
        OCSymbolWithQualifiedName oCSymbolWithQualifiedName = owner = functionSymbol != null ? functionSymbol.getResolvedOwner(context) : null;
        while (owner != null) {
            if (owner.equals(container)) {
                return true;
            }
            if (owner instanceof OCStructSymbol && container instanceof OCStructSymbol && ((OCStructSymbol)container).isAncestor((OCStructSymbol)owner, context)) {
                return true;
            }
            owner = owner.getResolvedOwner(context);
        }
        return false;
    }
}

