/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.introduce;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCRefactoringBundle;
import com.jetbrains.cidr.lang.intentions.OCMoveToPrivateCategoryIntentionAction;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCInterface;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCPropertyAttributesList;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.quickfixes.OCReleaseVariablesIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCSynthesizePropertyQuickFix;
import com.jetbrains.cidr.lang.refactoring.introduce.OCBaseExpressionInplaceIntroducer;
import com.jetbrains.cidr.lang.refactoring.introduce.OCBaseLocalConvertibleHandler;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCEnumComboOption;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbolImpl;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collections;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class OCPropertyInplaceIntroducer
extends OCBaseExpressionInplaceIntroducer<OCDeclarator, PsiElement> {
    public static final OCEnumComboOption<OCPropertySymbol.PropertySemantics> PROPERTY_SEMANTICS = new OCEnumComboOption<OCPropertySymbol.PropertySemantics>(OCRefactoringBundle.message("property.inplace.introducer.label.semantics", new Object[0]), (T[])OCPropertySymbol.PropertySemantics.values(), "default", "strong", "weak", "assign", "retain", "copy");
    public static final boolean CONVERT_USAGES_DEFAULT = true;
    public static final boolean READONLY_DEFAULT = false;
    private JCheckBox myReadonlyCB;
    private JCheckBox mySynthesizeCB;
    private JCheckBox myGenerateIvarCB;
    private JCheckBox myConvertUsagesCB;
    protected JCheckBox myPutToPrivateCategoryCB;
    protected Computable<OCPropertySymbol.PropertySemantics> mySemantics = () -> null;
    protected boolean myReadonly = false;
    protected boolean myConvertUsages = true;
    protected RangeMarker myExtraOccurrenceMarker;

    public OCPropertyInplaceIntroducer(Project project, Editor editor, PsiElement expression, List<PsiElement> occurrences, @NlsContexts.Command String refactoringName) {
        super(project, editor, expression, occurrences, OCDeclarator.class, PsiElement.class, refactoringName);
    }

    @Override
    public void configurePanel() {
        OCImplementationSymbol implementation;
        super.configurePanel();
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getSettings((Editor)this.myEditor).getCustomSettings(OCCodeStyleSettings.class);
        if (this.myExprType.isPointerToObjectCompatible()) {
            OCEnumComboOption<OCPropertySymbol.PropertySemantics> option = PROPERTY_SEMANTICS;
            JPanel component = option.createComponent();
            this.mySemantics = () -> (OCPropertySymbol.PropertySemantics)((Object)((Object)option.getSelectedValue(component)));
            for (Component kidComponent : component.getComponents()) {
                kidComponent.setFocusable(false);
            }
            option.selectValue(component, OCPropertySymbolImpl.getDefaultSemanticsForType(this.myExprType, this.myExpr));
            option.addItemListener(component, new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    OCPropertyInplaceIntroducer.this.changePropertyAttributes((OCPropertySymbol.PropertySemantics)((Object)OCPropertyInplaceIntroducer.this.mySemantics.compute()));
                }
            });
            OCPropertyInplaceIntroducer.addControl(this.myWholePanel, component);
        }
        if (this.askToConvertUsages()) {
            String iVarsToPropsMessage = OCBundle.message("refactoring.convertIvarUsagesToProperties", new Object[0]);
            this.myConvertUsagesCB = this.createCheckBox(iVarsToPropsMessage, true, () -> {
                this.myConvertUsages = this.myConvertUsagesCB.isSelected();
            });
        }
        if (this.isCreateFromUsageMode()) {
            this.myReadonlyCB = this.createCheckBox(OCRefactoringBundle.message("refactoring.property.introducer.make.readonly", new Object[0]), false, () -> {
                this.myReadonly = this.myReadonlyCB.isSelected();
                this.changePropertyAttributes((OCPropertySymbol.PropertySemantics)((Object)((Object)this.mySemantics.compute())));
            });
        } else {
            this.myReadonly = false;
        }
        if (this.askToGenerateSynthesize()) {
            this.mySynthesizeCB = this.createCheckBox(OCRefactoringBundle.message("refactoring.property.introducer.generate.synthesize", new Object[0]), settings.INTRODUCE_GENERATE_SYNTHESIZE, () -> {
                settings.INTRODUCE_GENERATE_SYNTHESIZE = this.mySynthesizeCB.isSelected();
                this.myGenerateIvarCB.setEnabled(this.mySynthesizeCB.isSelected());
            });
            this.myGenerateIvarCB = this.createCheckBox(OCRefactoringBundle.message("refactoring.property.introducer.generate.instance.variable", new Object[0]), settings.GENERATE_INSTANCE_VARIABLES_FOR_PROPERTIES == OCCodeStyleSettings.RememberedOption.YES, null);
            this.myGenerateIvarCB.setEnabled(this.mySynthesizeCB.isSelected());
        }
        if (this.myParentSymbol instanceof OCClassSymbol && (implementation = ((OCClassSymbol)this.myParentSymbol).getImplementation(this.myProject)) != null && Comparing.equal((Object)this.myExpr.getContainingFile(), (Object)implementation.getContainingOCFile(this.myProject))) {
            this.myPutToPrivateCategoryCB = this.createCheckBox(OCRefactoringBundle.message("refactoring.property.introducer.put.to.private.category", new Object[0]), settings.INTRODUCE_PROP_TO_PRIVATE_CATEGORY, () -> {
                settings.INTRODUCE_PROP_TO_PRIVATE_CATEGORY = this.myPutToPrivateCategoryCB.isSelected();
            });
        }
    }

    protected boolean askToGenerateSynthesize() {
        PsiFile referenceFile = this.myVarFile;
        if (referenceFile == null && this.myParentSymbol instanceof OCClassSymbol) {
            OCImplementationSymbol implementation = ((OCClassSymbol)this.myParentSymbol).getImplementation(this.myProject);
            OCFile oCFile = referenceFile = implementation == null ? null : implementation.getContainingOCFile(this.myProject);
        }
        if (referenceFile == null) {
            return false;
        }
        return !OCCompilerFeaturesHelper.supportsAutosynthesis(referenceFile) && !(this.myExpr.getParent() instanceof OCSynthesizeProperty);
    }

    protected boolean askToConvertUsages() {
        return false;
    }

    public boolean isConvertUsages() {
        return this.myConvertUsages;
    }

    @Override
    protected OCSymbolKind getDeclaratorKind() {
        return OCSymbolKind.PROPERTY;
    }

    private void changePropertyAttributes(OCPropertySymbol.PropertySemantics semantics) {
        WriteCommandAction.writeCommandAction((Project)this.myProject).withName(this.myTitle).withGroupId(this.myTitle).run(() -> {
            OCProperty oldProperty = (OCProperty)PsiTreeUtil.getParentOfType(this.getVariable(), OCProperty.class);
            if (oldProperty != null) {
                OCProperty newProperty = OCElementFactory.propertyDeclaration("pr", this.myExprType, oldProperty, semantics, this.myReadonly);
                OCPropertyAttributesList attrList = oldProperty.getPropertyAttributesList();
                if (attrList != null) {
                    OCChangeUtil.replaceHandlingMacros(attrList, newProperty.getPropertyAttributesList());
                }
            }
        });
    }

    @Override
    protected String checkExpression(PsiElement expression) {
        if (expression.getParent() instanceof OCSynthesizeProperty) {
            return null;
        }
        String message = super.checkExpression(expression);
        if (message != null) {
            return message;
        }
        if (this.myParentSymbol == null) {
            OCBlockStatement block = (OCBlockStatement)PsiTreeUtil.getContextOfType((PsiElement)this.myExpr, (boolean)false, (Class[])new Class[]{OCBlockStatement.class});
            OCMethod method = (OCMethod)PsiTreeUtil.getContextOfType((PsiElement)block, (boolean)false, (Class[])new Class[]{OCMethod.class});
            if (method == null || !method.isInstanceMethod()) {
                return OCRefactoringBundle.message("selected.expression.should.be.inside.an.instance.method1", new Object[0]);
            }
            OCClassDeclaration classDecl = (OCClassDeclaration)PsiTreeUtil.getParentOfType((PsiElement)method, OCClassDeclaration.class);
            this.myParentSymbol = classDecl != null ? classDecl.getSymbol() : null;
        }
        return null;
    }

    @Override
    public PsiElement evaluateAnchor() {
        if (this.myExpr.getParent() instanceof OCSynthesizeProperty) {
            return this.myExpr.getParent().getPrevSibling();
        }
        return super.evaluateAnchor();
    }

    private OCDeclarator addProperty(String name, OCClassDeclaration parent, PsiElement anchor, boolean previewMode) {
        OCProperty property = OCElementFactory.propertyDeclaration(name, this.myExprType, parent, (OCPropertySymbol.PropertySemantics)((Object)this.mySemantics.compute()), this.myReadonly);
        property = OCChangeUtil.addBefore(parent, property, anchor);
        Object mainExpression = this.getMainExpression();
        Object initializer = OCBaseLocalConvertibleHandler.isDeclaratorIdentifier(mainExpression) ? ((OCDeclarator)mainExpression.getParent()).getInitializer() : mainExpression;
        if (!this.isCreateFromUsageMode() && initializer != null) {
            OCStatement statement = OCElementFactory.statementFromText("self." + name + "=a;", (PsiElement)anchor.getContainingFile(), true);
            OCExpression source = ((OCAssignmentExpression)((OCExpressionStatement)statement).getExpression()).getSourceExpression();
            if (previewMode) {
                source.replace((PsiElement)initializer);
            } else {
                OCChangeUtil.replaceHandlingMacros(source, initializer);
            }
            anchor = this.ensureParentIsBlockStatement(anchor);
            if (mainExpression.getParent() instanceof OCExpressionStatement || OCBaseLocalConvertibleHandler.isDeclaratorIdentifier(mainExpression)) {
                OCStatement parentStmt = (OCStatement)PsiTreeUtil.getParentOfType(mainExpression.isValid() ? mainExpression : anchor, OCStatement.class, (boolean)false);
                statement = (OCStatement)OCChangeUtil.replaceHandlingMacros(parentStmt, statement);
            } else {
                statement = OCChangeUtil.addBefore(anchor.getParent(), statement, anchor);
            }
            OCExpression lvalue = ((OCAssignmentExpression)((OCExpressionStatement)statement).getExpression()).getReceiverExpression();
            if (previewMode) {
                PsiElement extraOccurrence = ((OCQualifiedExpression)lvalue).getNameIdentifier();
                this.myExtraOccurrenceMarker = this.addOccurrence(extraOccurrence);
                if (!this.myExpr.isValid()) {
                    this.myExpr = extraOccurrence;
                    this.myExprMarker = this.createMarker(this.myExpr);
                }
            }
        }
        return property.getDeclaration().getDeclarators().get(0);
    }

    @Override
    protected void introduceForPreview(String name) {
        PsiElement anchor = this.getAnchor();
        PsiElement parent = PsiTreeUtil.getContextOfType((PsiElement)anchor, (boolean)false, (Class[])new Class[]{OCImplementation.class, PsiFile.class});
        if (parent instanceof PsiFile) {
            OCInterface clazz = OCElementFactory.interfaceByName("i", anchor);
            parent = parent.add((PsiElement)clazz);
        }
        OCDeclarator declarator = this.addProperty(name, (OCClassDeclaration)parent, anchor, true);
        this.setVariable(declarator);
    }

    @Override
    protected void introduceForReal(String name) {
        OCSymbol propertySymbol;
        OCClassDeclaration classDecl;
        PsiElement anchor = this.getAnchor();
        OCClassSymbol classSymbol = this.myParentSymbol instanceof OCClassSymbol ? (OCClassSymbol)this.myParentSymbol : ((classDecl = (OCClassDeclaration)PsiTreeUtil.getContextOfType((PsiElement)anchor, (boolean)false, (Class[])new Class[]{OCImplementation.class})) != null ? classDecl.getSymbol() : null);
        OCInterfaceSymbol intfSymbol = classSymbol != null ? classSymbol.getInterface(this.myProject) : null;
        OCClassDeclaration<?> anInterface = OCElementUtil.resolveClassDeclaration(intfSymbol, this.myProject);
        if (anInterface == null || !CommonRefactoringUtil.checkReadOnlyStatus(anInterface)) {
            return;
        }
        OCDeclarator declarator = this.addProperty(name, anInterface, anchor, false);
        OCImportSymbolFix.fixAllSymbolsRecursively(declarator.getParent());
        PsiFile containingFile = declarator.getContainingFile();
        if (this.changeUsages(name)) {
            for (PsiElement occurrence : this.myOccurrences) {
                PsiElement qualifier;
                if (!occurrence.isValid()) continue;
                if (OCBaseLocalConvertibleHandler.isDeclaratorIdentifier(occurrence)) {
                    OCChangeUtil.delete(occurrence.getParent());
                    continue;
                }
                if (occurrence instanceof OCExpression) {
                    OCChangeUtil.replaceHandlingMacros(occurrence, OCElementFactory.expressionFromText("self." + name, occurrence));
                    continue;
                }
                if (this.isCreateFromUsageMode() || this.myExtraOccurrenceMarker == null || (qualifier = containingFile.findElementAt(this.myExtraOccurrenceMarker.getStartOffset())) == null || OCElementUtil.getElementType(qualifier) != OCTokenTypes.IDENTIFIER) continue;
                OCChangeUtil.replaceHandlingMacros(qualifier, OCElementFactory.createIdentifier(name, anchor));
            }
        }
        if ((propertySymbol = declarator.getSymbol()) instanceof OCPropertySymbol) {
            OCMoveToPrivateCategoryIntentionAction action;
            OCInstanceVariableSymbol ivar;
            if (this.mySynthesizeCB != null && this.mySynthesizeCB.isSelected()) {
                OCImplementationSymbol implementationSymbol = ((OCPropertySymbol)propertySymbol).getParent().getImplementation(this.myProject);
                OCSynthesizePropertyQuickFix action2 = new OCSynthesizePropertyQuickFix(implementationSymbol, (OCPropertySymbol)propertySymbol, this.myProject){

                    @Override
                    protected Boolean generateIvars(Project project) {
                        return OCPropertyInplaceIntroducer.this.myGenerateIvarCB.isSelected() || ApplicationManager.getApplication().isUnitTestMode();
                    }
                };
                if (action2.isAvailable(this.myProject, this.myEditor, containingFile)) {
                    action2.invoke(this.myProject, this.myEditor, containingFile);
                }
            } else if (OCCompilerFeaturesHelper.supportsAutosynthesis(containingFile) && OCCompilerFeaturesHelper.isArcDisabled(containingFile) && propertySymbol.getResolvedType(OCResolveContext.forPsi(declarator)).isPointerToObjectCompatible() && ((OCPropertySymbol)propertySymbol).isRetained() && (ivar = ((OCPropertySymbol)propertySymbol).getAssociatedIvar(this.myProject)) != null) {
                if (this.myEditor != null) {
                    PsiDocumentManager.getInstance((Project)this.myProject).doPostponedOperationsAndUnblockDocument(this.myEditor.getDocument());
                }
                OCReleaseVariablesIntentionAction action3 = new OCReleaseVariablesIntentionAction(Collections.singletonList(ivar), this.myProject);
                action3.invoke(this.myProject, this.myEditor, containingFile);
            }
            if (this.myPutToPrivateCategoryCB != null && this.myPutToPrivateCategoryCB.isSelected() && (action = new OCMoveToPrivateCategoryIntentionAction(){

                @Override
                protected OCMemberSymbol locateCandidate(@NotNull Project project, Editor editor, PsiFile file) {
                    return (OCMemberSymbol)propertySymbol;
                }
            }).isAvailable(this.myProject, this.myEditor, containingFile)) {
                action.invoke(this.myProject, this.myEditor, containingFile);
            }
        }
    }

    @Override
    @NotNull
    protected String getFeatureID() {
        return "refactoring.introduceProperty";
    }

    @Override
    public PsiElement getPreviewElement(OCDeclarator element) {
        return element.getParent().getParent();
    }
}

