/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.introduce;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.refactoring.OCNamingConventionUtil;
import com.jetbrains.cidr.lang.refactoring.introduce.OCBaseInplaceIntroducer;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDefineInplaceIntroducer
extends OCBaseInplaceIntroducer<OCDefineDirective, OCElement> {
    public OCDefineInplaceIntroducer(Project project, Editor editor, OCElement expression, List<OCElement> occurrences, @NlsContexts.Command String refactoringName) {
        super(project, editor, expression, occurrences, OCDefineDirective.class, OCElement.class, refactoringName);
    }

    protected String @NotNull [] suggestNames(boolean replaceAll, @Nullable OCDefineDirective variable) {
        String nameToSuggest = OCNamingConventionUtil.applyNamingConvention(this.myUsageName != null ? this.myUsageName : "DEF", OCSymbolKind.MACRO, this.myProject);
        return new String[]{nameToSuggest};
    }

    @Override
    protected String checkExpression(OCElement expression) {
        return null;
    }

    @Override
    public PsiElement evaluateAnchor() {
        OCElement parent = (OCElement)PsiTreeUtil.getContextOfType((PsiElement)this.getCommonContext(), (boolean)false, (Class[])new Class[]{OCFile.class});
        return parent != null ? this.findAnchor(parent) : null;
    }

    private void doIntroduce(String name, boolean isPreview) {
        PsiElement anchor = this.getAnchor();
        OCDefineDirective declaration = (OCDefineDirective)OCElementFactory.topLevelDeclarationFromText(this.getDefineText(name), anchor);
        OCDefineDirective newDirective = OCChangeUtil.addBefore(this.getAnchorParent(anchor, isPreview), declaration, anchor);
        OCChangeUtil.addNewLineIfNeed(newDirective, true);
        if (isPreview) {
            this.setVariable(newDirective);
        }
    }

    @Override
    protected OCDefineDirective getVariable() {
        OCDefineDirective variable = (OCDefineDirective)super.getVariable();
        if (variable != null && variable.getNameIdentifier() == null) {
            return null;
        }
        return variable;
    }

    @Override
    protected void introduceForPreview(String name) {
        this.doIntroduce(name, true);
    }

    @Override
    protected void introduceForReal(String name) {
        this.doIntroduce(name, false);
        OCElement mainExpression = (OCElement)this.getMainExpression();
        Document document = this.myEditor.getDocument();
        this.initOccurrencesMarkers();
        PsiDocumentManager.getInstance((Project)this.myProject).doPostponedOperationsAndUnblockDocument(document);
        for (RangeMarker marker : this.myOccurrenceMarkers) {
            String macroCallText = name + (mainExpression instanceof OCStatement || mainExpression instanceof OCDeclaration ? ";" : "");
            document.replaceString(marker.getStartOffset(), marker.getEndOffset(), (CharSequence)macroCallText);
        }
        PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(document);
    }

    @Override
    @NotNull
    protected String getFeatureID() {
        return "refactoring.introduceDefine";
    }

    @NotNull
    private static String getTextWithLineCommentsReplacedWithBlockComments(@NotNull OCElement expression) {
        Object text = expression.getTextWithMacros().trim();
        int correction = 0;
        for (PsiComment comment : PsiTreeUtil.findChildrenOfType((PsiElement)expression, PsiComment.class)) {
            int offset = comment.getStartOffsetInParent();
            int len = comment.getTextLength();
            if (!comment.getText().startsWith("//") || offset + len >= ((String)text).length()) continue;
            text = ((String)text).substring(0, offset + correction) + "/*" + comment.getText().substring(2) + "*/" + ((String)text).substring(offset + len + correction);
            correction += 2;
        }
        return text;
    }

    private String getDefineText(String name) {
        OCElement mainExpression = (OCElement)this.getMainExpression();
        String mainText = OCDefineInplaceIntroducer.getTextWithLineCommentsReplacedWithBlockComments((OCElement)this.getMainExpression());
        String[] lines = mainText.split("\n");
        for (int i = 0; i < lines.length - 1; ++i) {
            if (lines[i].trim().endsWith("\\")) continue;
            int n = i;
            lines[n] = lines[n] + "\\";
        }
        Object declarationText = "#define " + name + " " + String.join((CharSequence)"\n", Arrays.asList(lines));
        if ((mainExpression instanceof OCStatement || mainExpression instanceof OCDeclaration) && ((String)declarationText).endsWith(";")) {
            declarationText = ((String)declarationText).substring(0, ((String)declarationText).length() - 1);
        }
        declarationText = (String)declarationText + "\n\n";
        return declarationText;
    }
}

