/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.introduce;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.OCRefactoringBundle;
import com.jetbrains.cidr.lang.daemon.OCConstantExpressionVisitor;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.refactoring.introduce.OCBaseExpressionInplaceIntroducer;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCConstantInplaceIntroducer
extends OCBaseExpressionInplaceIntroducer<OCDeclarator, OCExpression> {
    private JCheckBox myStaticCB;

    public OCConstantInplaceIntroducer(Project project, Editor editor, OCExpression expression, List<OCExpression> occurrences, @NlsContexts.Command String refactoringName) {
        super(project, editor, expression, occurrences, OCDeclarator.class, OCExpression.class, refactoringName);
    }

    @Override
    public void configurePanel() {
        super.configurePanel();
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getSettings((Editor)this.myEditor).getCustomSettings(OCCodeStyleSettings.class);
        this.myStaticCB = this.createCheckBox(OCRefactoringBundle.message("refactoring.introduce.constant.static.declaration", new Object[0]), settings.INTRODUCE_STATIC_CONSTS, () -> {
            settings.INTRODUCE_STATIC_CONSTS = this.myStaticCB.isSelected();
            this.rebuildDeclaration();
        });
    }

    private void rebuildDeclaration() {
        OCDeclarator declarator = (OCDeclarator)this.getVariable();
        if (declarator != null) {
            OCDeclaration newDeclaration = this.createDeclaration(declarator.getName(), declarator.getInitializer());
            OCChangeUtil.replaceHandlingMacros(declarator.getParent(), newDeclaration);
        }
    }

    @Override
    protected OCSymbolKind getDeclaratorKind() {
        return OCSymbolKind.GLOBAL_VARIABLE;
    }

    @Override
    @Nullable
    protected String checkExpression(OCExpression expression) {
        String message = this.checkType();
        if (message != null) {
            return message;
        }
        if (!new OCConstantExpressionVisitor(){

            @Override
            protected boolean isConstDeclarator(OCReferenceExpression expression, OCSymbol symbol) {
                return super.isConstDeclarator(expression, symbol) && symbol.isGlobal();
            }
        }.isConstant(expression)) {
            return OCRefactoringBundle.message("selected.expression.cannot.be.a.constant.initializer", new Object[0]);
        }
        return null;
    }

    @Override
    public PsiElement evaluateAnchor() {
        OCElement parent = (OCElement)PsiTreeUtil.getContextOfType((PsiElement)this.getCommonContext(), (boolean)false, (Class[])new Class[]{OCCppNamespace.class, OCFile.class});
        return parent != null ? this.findAnchor(parent) : null;
    }

    private OCDeclaration createDeclaration(String name, OCExpression initializer) {
        ArrayList<String> modifiers = new ArrayList<String>();
        if (this.myStaticCB.isSelected()) {
            modifiers.add("static");
        }
        Object declarationText = OCElementFactory.declarationText(modifiers, name, this.myExprType.cloneWithConstModifier(this.myProject), "0", initializer, null, false);
        if (((String)(declarationText = OCElementFactory.declarationFromText((String)declarationText, initializer, true).getTextWithMacros())).endsWith("0;")) {
            declarationText = ((String)declarationText).substring(0, ((String)declarationText).length() - 2) + initializer.getTextWithMacros() + ";";
        } else {
            LOG.error((String)declarationText);
        }
        return OCElementFactory.declarationFromText((String)declarationText, initializer);
    }

    private OCDeclaration doIntroduce(String name, boolean isPreview) {
        OCExpression mainExpression = (OCExpression)this.getMainExpression();
        PsiElement anchor = this.getAnchor();
        OCDeclaration declarationInFragment = this.createDeclaration(name, mainExpression);
        OCDeclaration declarationInFile = OCChangeUtil.addBefore(this.getAnchorParent(anchor, isPreview), declarationInFragment, anchor);
        OCChangeUtil.addNewLineIfNeed(declarationInFile, true);
        if (isPreview) {
            this.setVariable(declarationInFile.getDeclarators().get(0));
        }
        return declarationInFile;
    }

    @Override
    protected void introduceForPreview(String name) {
        this.doIntroduce(name, true);
    }

    @Override
    protected void introduceForReal(String name) {
        OCDeclaration declaration = this.doIntroduce(name, false);
        OCImportSymbolFix.fixAllSymbolsRecursively(declaration);
        for (OCExpression expression : (OCExpression[])this.myOccurrences) {
            OCChangeUtil.replaceHandlingMacros(expression, OCElementFactory.expressionFromText(name, expression));
        }
    }

    @Override
    @NotNull
    protected String getFeatureID() {
        return "refactoring.introduceConstant";
    }

    @Override
    public PsiElement getPreviewElement(OCDeclarator element) {
        return element.getParent();
    }
}

