/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.changeSignature.usages;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCMessageArgument;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeInfo;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCParameterInfo;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCUsageInfo;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;

public class OCParameterUsage
extends OCUsageInfo<PsiElement> {
    private OCParameterInfo myNewParam;
    private boolean myInherited;
    private OCCallable myCallable;

    public OCParameterUsage(@NotNull PsiReference reference, OCParameterInfo newParam, OCCallable callable, boolean isInherited) {
        super(reference);
        this.myNewParam = newParam;
        this.myCallable = callable;
        this.myInherited = isInherited;
    }

    @Override
    public boolean processUsage(@NotNull OCChangeInfo changeInfo, @NotNull PsiElement element, @NotNull Project project) {
        if (this.myNewParam.getName().isEmpty()) {
            return true;
        }
        if (element.getTextLength() == 0) {
            return true;
        }
        String newName = changeInfo.getNewParameterName(this.myInherited, this.myCallable, this.myNewParam);
        if (this.myNewParam.isReferenceMode()) {
            PsiElement parent = element.getParent();
            if (!(parent instanceof OCReferenceExpression)) {
                return false;
            }
            if (parent.getParent() instanceof OCSendMessageExpression || parent.getParent() instanceof OCMessageArgument || parent.getParent() instanceof OCParenthesizedExpression) {
                OCChangeUtil.replaceHandlingMacros(parent, OCElementFactory.expressionFromText("*" + newName, element));
            } else if (parent.getParent() instanceof OCUnaryExpression && ((OCUnaryExpression)parent.getParent()).isGetAddress()) {
                OCChangeUtil.replaceHandlingMacros(parent.getParent(), OCElementFactory.expressionFromText(newName, element));
            } else {
                OCChangeUtil.replaceHandlingMacros(parent, OCElementFactory.expressionFromText("(*" + newName + ")", element));
            }
        } else if (element instanceof OCReferenceElement) {
            OCElementUtil.replaceWithIdentifier(((OCReferenceElement)element).getNameIdentifier(), newName, element);
        } else if (element instanceof PsiNamedElement) {
            ((PsiNamedElement)element).setName(newName);
        }
        return true;
    }
}

