/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.changeSignature.usages;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCConstructorFieldInitializer;
import com.jetbrains.cidr.lang.psi.OCCppNewExpression;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeInfo;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureUsageProcessor;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCUsageInfo;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import org.jetbrains.annotations.NotNull;

public class OCFunctionUsage
extends OCUsageInfo<OCElement> {
    public OCFunctionUsage(@NotNull PsiReference reference) {
        super(reference);
    }

    @Override
    public boolean processUsage(@NotNull OCChangeInfo changeInfo, @NotNull OCElement element, @NotNull Project project) {
        OCElement call = element instanceof OCDeclarator || element instanceof OCConstructorFieldInitializer ? element : (element.getParent() instanceof OCConstructorFieldInitializer ? (OCElement)element.getParent() : (OCElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{OCCastExpression.class, OCUnaryExpression.class, OCBinaryExpression.class, OCCallExpression.class, OCCppNewExpression.class}));
        boolean needReformat = false;
        if (call != null && changeInfo.isParameterSetOrOrderChanged()) {
            if (changeInfo.willBeBlockOrLambda() || changeInfo.willBeMethod()) {
                assert (call instanceof OCCallExpression);
                PsiElement newCall = OCChangeSignatureUsageProcessor.generateCall(null, ((OCCallExpression)call).getArguments(), null, changeInfo);
                newCall = OCChangeUtil.replaceHandlingMacros(call, newCall);
                OCImportSymbolFix.fixAllSymbolsRecursively(newCall);
            } else {
                OCChangeSignatureUsageProcessor.changeConstructorOrMethodCall(call, changeInfo);
                needReformat = true;
            }
        } else if (changeInfo.isNameChanged()) {
            String newName = changeInfo.getNewName();
            if (element instanceof OCReferenceElement) {
                ((OCReferenceElement)element).setNameOfIdentifier(newName);
            } else if (element instanceof PsiNamedElement) {
                ((PsiNamedElement)element).setName(newName);
            }
            needReformat = true;
        }
        if (call != null && needReformat) {
            OCChangeUtil.reformatElementAfterInsertionIfNeed(call);
        }
        return true;
    }
}

