/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.changeSignature.usages;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCConstructorFieldInitializer;
import com.jetbrains.cidr.lang.psi.OCConstructorInitializationList;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCReturnStatement;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeInfo;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureUsageProcessor;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCUsageInfo;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.search.constructors.OCBaseConstructorReference;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCConstructorInEmptyInitializationUsage
extends OCUsageInfo<OCElement> {
    private OCBaseConstructorReference myReference;

    public OCConstructorInEmptyInitializationUsage(@NotNull OCBaseConstructorReference reference) {
        super(reference);
        this.myReference = reference;
    }

    @NotNull
    public OCBaseConstructorReference getCtorReference() {
        return this.myReference;
    }

    static OCConstructorInitializationList getConstructorInitializationList(OCFunctionDefinition function) {
        OCConstructorInitializationList list = function.getConstructorInitializationList();
        if (list == null) {
            list = function.setConstructorInitializationList(OCElementFactory.constructorInitializationList(function));
        }
        return list;
    }

    private static boolean processNonSymbolUsage(@NotNull OCChangeInfo changeInfo, @NotNull OCElement element) {
        OCExpression init = null;
        if (element instanceof OCReturnStatement) {
            init = ((OCReturnStatement)element).getExpression();
        }
        if (init instanceof OCCastExpression) {
            init = ((OCCastExpression)init).getOperand();
        }
        if (init != null) {
            OCChangeSignatureUsageProcessor.changeConstructorOrMethodCall(init, changeInfo);
        }
        return true;
    }

    @Override
    public boolean processUsage(@NotNull OCChangeInfo changeInfo, @NotNull OCElement element, @NotNull Project project) {
        if (changeInfo.isParameterSetOrOrderChanged()) {
            PsiElement referenceField = this.myReference.getField();
            if (!(referenceField instanceof OCSymbolDeclarator)) {
                return OCConstructorInEmptyInitializationUsage.processNonSymbolUsage(changeInfo, element);
            }
            String text = ((OCSymbolDeclarator)referenceField).getSymbol().getName() + "()";
            OCConstructorFieldInitializer initializer = OCElementFactory.constructorFieldInitializerFromText(text, element);
            OCChangeSignatureUsageProcessor.changeConstructorOrMethodCall(initializer, changeInfo);
            if (element instanceof OCFunctionDefinition) {
                OCChangeUtil.add(OCConstructorInEmptyInitializationUsage.getConstructorInitializationList((OCFunctionDefinition)element), initializer);
            } else if (element instanceof OCStruct) {
                OCFunctionDeclaration constructor;
                List<OCFunctionDeclaration> constructors = ((OCStruct)element).getConstructors();
                if (constructors.size() == 0) {
                    String constructorText = ((OCStruct)element).getName() + "() {}";
                    constructor = (OCFunctionDefinition)OCElementFactory.constructorFromText(constructorText, element);
                    OCChangeUtil.add(element, constructor);
                } else {
                    constructor = constructors.get(0);
                }
                OCChangeUtil.add(OCConstructorInEmptyInitializationUsage.getConstructorInitializationList((OCFunctionDefinition)constructor), initializer);
            }
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OCConstructorInEmptyInitializationUsage that = (OCConstructorInEmptyInitializationUsage)o;
        PsiElement thisField = this.myReference.getField();
        PsiElement thatField = that.myReference.getField();
        if (thisField instanceof OCSymbolDeclarator && thatField instanceof OCSymbolDeclarator) {
            return Comparing.equal(((OCSymbolDeclarator)thisField).getSymbol(), ((OCSymbolDeclarator)thatField).getSymbol());
        }
        return Comparing.equal((Object)thisField, (Object)thatField);
    }
}

