/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.changeSignature;

import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class OCCallableKind
extends Enum<OCCallableKind> {
    public static final /* enum */ OCCallableKind METHOD = new OCCallableKind();
    public static final /* enum */ OCCallableKind FUNCTION = new OCCallableKind();
    public static final /* enum */ OCCallableKind BLOCK = new OCCallableKind();
    public static final /* enum */ OCCallableKind LAMBDA = new OCCallableKind();
    private static final /* synthetic */ OCCallableKind[] $VALUES;

    public static OCCallableKind[] values() {
        return (OCCallableKind[])$VALUES.clone();
    }

    public static OCCallableKind valueOf(String name) {
        return Enum.valueOf(OCCallableKind.class, name);
    }

    @NotNull
    @Nls
    public String getPresentableName() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case METHOD -> OCBundle.message("method", new Object[0]);
            case FUNCTION -> OCBundle.message("function", new Object[0]);
            case BLOCK -> OCBundle.message("block", new Object[0]);
            case LAMBDA -> OCBundle.message("lambda", new Object[0]);
        };
    }

    @NotNull
    public String toString() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case METHOD -> "Method";
            case FUNCTION -> "Function";
            case BLOCK -> "Block";
            case LAMBDA -> "Lambda";
        };
    }

    public String toStringLowercase() {
        return StringUtil.decapitalize((String)this.toString());
    }

    public OCSymbolKind getSymbolKind() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case METHOD -> OCSymbolKind.METHOD;
            case FUNCTION -> OCSymbolKind.FUNCTION_DECLARATION;
            case BLOCK -> OCSymbolKind.BLOCK;
            case LAMBDA -> OCSymbolKind.LAMBDA;
        };
    }

    public static OCCallableKind parse(String value) {
        for (OCCallableKind kind : OCCallableKind.values()) {
            if (!kind.toString().equals(value)) continue;
            return kind;
        }
        assert (false) : "Unknown callable kind: " + value;
        return null;
    }

    private static /* synthetic */ OCCallableKind[] $values() {
        return new OCCallableKind[]{METHOD, FUNCTION, BLOCK, LAMBDA};
    }

    static {
        $VALUES = OCCallableKind.$values();
    }
}

