/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCRefactoringBundle;
import com.jetbrains.cidr.lang.daemon.OCGetSymbolVisitor;
import com.jetbrains.cidr.lang.dfa.OCDataFlowAnalyzer;
import com.jetbrains.cidr.lang.dfa.OCUnreachableCodeFinder;
import com.jetbrains.cidr.lang.psi.OCArraySelectionExpression;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCForeachStatement;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCReturnStatement;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.refactoring.OCExtractMethodHandler;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.OCUniqueNameGenerator;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCCallableKind;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureActionHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCEmptyChangeSignatureHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCParameterInfo;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCFunctionUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCMethodCallUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCUsageRank;
import com.jetbrains.cidr.lang.refactoring.move.OCCodeMoveValidator;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.search.usages.OCReadWriteAccessDetector;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCQualifiedNameWithArguments;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceTypeSimple;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.util.OCCallableUtil;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCExtractMethodProcessor {
    private OCDataFlowAnalyzer analyzer;
    private OCChangeSignatureHandler handler;
    private final DataContext dataContext;
    private OCCallableKind callableKind;
    private final Project project;
    private final TextRange selection;
    private PsiElement firstElement;
    private final PsiElement[] elements;
    private OCType parentReturnType;
    private boolean nonVoidParentReturnType;
    private boolean hasReturnNodes;
    private boolean hasStatementsAfter;
    private OCCallable<?> parentCallable;
    private OCSymbol parentCallableSymbol;
    private OCStructType memberAccessType;

    OCExtractMethodProcessor(PsiElement[] elements, Project project, TextRange selection, DataContext dataContext) {
        this.elements = elements;
        this.project = project;
        this.selection = selection;
        this.dataContext = dataContext;
    }

    public void invoke(Editor editor) {
        OCChangeSignatureHandler lambdaHandler;
        if (this.elements.length == 0) {
            return;
        }
        this.firstElement = this.elements[0];
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)this.project, (PsiElement)this.firstElement)) {
            return;
        }
        if (!this.analyze(editor)) {
            return;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.generateName(null);
        }
        ApplicationManager.getApplication().runWriteAction(() -> this.handleInputOutputVars());
        if (this.callableKind == OCCallableKind.BLOCK || this.callableKind == OCCallableKind.LAMBDA) {
            lambdaHandler = OCChangeSignatureActionHandler.getHandler(this.parentCallable, this.handler.getMethodDescriptor().getMethod(), false, true, !ApplicationManager.getApplication().isUnitTestMode(), false);
            if (lambdaHandler instanceof OCEmptyChangeSignatureHandler) {
                return;
            }
        } else {
            lambdaHandler = null;
        }
        this.handler.getGeneratedInfo().runOnSuccess(() -> {
            List<OCCallable> newMethods = this.handler.getNewCallables();
            if (newMethods != null && !newMethods.isEmpty()) {
                for (PsiElement element : this.elements) {
                    if (!element.isValid()) continue;
                    OCChangeUtil.deleteUnsafe(element);
                }
                if (this.callableKind == OCCallableKind.BLOCK || this.callableKind == OCCallableKind.LAMBDA) {
                    this.extractLambdaParameter((OCExpression)((Object)this.handler.getChangeInfo().getMethod()), lambdaHandler);
                }
            }
        });
        this.handler.invoke();
    }

    private boolean analyze(Editor editor) {
        OCCallable<OCMethodSymbol> methodStub;
        this.parentCallable = (OCCallable)PsiTreeUtil.getParentOfType((PsiElement)this.firstElement, (Class[])new Class[]{OCMethod.class, OCFunctionDefinition.class});
        if (this.parentCallable == null) {
            this.parentCallable = (OCCallable)PsiTreeUtil.getParentOfType((PsiElement)this.firstElement, (Class[])new Class[]{OCBlockExpression.class, OCLambdaExpression.class});
        }
        if (this.parentCallable == null) {
            return false;
        }
        this.parentCallableSymbol = this.parentCallable.getSymbol();
        OCClassSymbol parentClass = null;
        boolean isStatic = false;
        this.callableKind = (OCCallableKind)((Object)OCChangeSignatureActionHandler.CALLABLE_KIND.getData(this.dataContext));
        this.parentReturnType = null;
        if (this.callableKind == null) {
            OCCallableKind oCCallableKind = this.callableKind = this.parentCallable instanceof OCMethod ? OCCallableKind.METHOD : OCCallableKind.FUNCTION;
        }
        if (this.parentCallableSymbol instanceof OCMethodSymbol && this.callableKind != OCCallableKind.BLOCK) {
            parentClass = ((OCMethodSymbol)this.parentCallableSymbol).getParent();
            String signature2 = (((OCMethodSymbol)this.parentCallableSymbol).isStatic() ? "+" : "-") + "(void) f";
            methodStub = OCElementFactory.methodFromSignature(signature2, this.parentCallable.getParent(), true, false);
        } else {
            String qualifier = "";
            if (this.parentCallableSymbol instanceof OCSymbolWithQualifiedName) {
                String fullName = ((OCSymbolWithQualifiedName)this.parentCallableSymbol).getQualifiedName().getFullName(OCResolveContext.forPsi(this.firstElement));
                int index = fullName.lastIndexOf("::");
                qualifier = index > 0 ? fullName.substring(0, index + 2) : "";
            }
            OCResolveContext context = OCResolveContext.forPsi(this.parentCallable);
            isStatic = this.parentCallableSymbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)this.parentCallableSymbol).resolveIsFriendOrStatic(context);
            String signature3 = "void " + qualifier + "f()";
            if (isStatic && (((OCFunctionSymbol)this.parentCallableSymbol).getParent() instanceof OCStructSymbol || !(((OCFunctionSymbol)this.parentCallableSymbol).getResolvedOwner(context) instanceof OCStructSymbol))) {
                signature3 = "static " + signature3;
            }
            if (this.canBeConst()) {
                signature3 = signature3 + " const";
            }
            if (this.parentCallableSymbol != null && this.parentCallableSymbol.getType().isVolatile()) {
                signature3 = signature3 + " volatile";
            }
            methodStub = (OCCallable)OCElementFactory.topLevelDeclarationFromText(signature3 + "{}", this.parentCallable.getParent());
        }
        this.parentReturnType = this.parentCallable.getReturnType().resolve(this.parentCallable);
        this.nonVoidParentReturnType = !this.parentReturnType.isVoid();
        PsiElement parent = OCChangeUtil.getAppropriateParent(this.callableKind.getSymbolKind(), this.firstElement);
        PsiElement insertionPoint = OCChangeUtil.getRealAnchorForInsertion(parent, this.firstElement);
        if (insertionPoint == null) {
            return false;
        }
        this.handler = OCChangeSignatureActionHandler.getHandler((OCCallable)methodStub, insertionPoint);
        switch (this.callableKind) {
            case METHOD: {
                this.handler.setTitle(OCRefactoringBundle.message("dialog.title.extract.method", new Object[0]));
                break;
            }
            case FUNCTION: {
                this.handler.setTitle(OCRefactoringBundle.message("dialog.title.extract.function", new Object[0]));
                break;
            }
            case BLOCK: {
                this.handler.setTitle(OCRefactoringBundle.message("dialog.title.extract.block.parameter", new Object[0]));
                break;
            }
            case LAMBDA: {
                this.handler.setTitle(OCRefactoringBundle.message("dialog.title.extract.lambda.parameter", new Object[0]));
            }
        }
        this.handler.setHelpId(this.callableKind == OCCallableKind.LAMBDA ? "refactoring.extractLambdaParameter" : "refactoring.extractMethod");
        this.handler.setRefactorButtonText(OCRefactoringBundle.message("button.extract", new Object[0]));
        this.handler.setCallableKind(this.callableKind);
        if (this.callableKind == OCCallableKind.BLOCK) {
            this.prepareBlockParameter();
        }
        PsiElement element = this.firstElement;
        PsiElement prevElement = OCElementUtil.getPrevSiblingOrParentSibling(element);
        while (prevElement instanceof OCMacroCall) {
            element = prevElement;
            prevElement = OCElementUtil.getPrevSiblingOrParentSibling(element);
        }
        this.handler.setChangeUsages(false);
        this.handler.getGeneratedInfo().setMethodReference(PsiTreeUtil.prevLeaf((PsiElement)element));
        this.handler.getGeneratedInfo().setMethodParent(parentClass, true, Collections.emptyList());
        this.handler.getGeneratedInfo().setStatic(isStatic);
        this.analyzer = new OCDataFlowAnalyzer(this.parentCallable, this.selection);
        this.analyzer.buildControlFlowGraph();
        this.analyzer.analyze();
        final TextRange range = new TextRange(this.elements[this.elements.length - 1].getTextRange().getEndOffset(), this.parentCallable.getTextRange().getEndOffset());
        this.parentCallable.accept(new OCRecursiveVisitor(range){

            @Override
            public void visitStatement(OCStatement stmt) {
                super.visitStatement(stmt);
                if (range.contains(stmt.getTextRange())) {
                    OCExtractMethodProcessor.this.hasStatementsAfter = true;
                }
            }
        });
        String message = this.checkValidity();
        if (message != null) {
            CommonRefactoringUtil.showErrorHint((Project)this.project, (Editor)editor, (String)message, (String)OCExtractMethodHandler.getRefactoringName(), null);
            return false;
        }
        return true;
    }

    private OCParameterInfo addParameter(List<OCSymbol> parameters, Map<OCSymbol, OCParameterInfo> paramsMap, OCSymbol var, boolean isReferenceMode, boolean wasNonConstUsage) {
        String selectorName;
        int paramIndex;
        if (paramsMap.containsKey(var)) {
            this.handler.removeParameter(var.getName(), false);
            paramsMap.remove(var);
            paramIndex = parameters.indexOf(var);
            parameters.set(paramIndex, var);
            selectorName = var.getName();
        } else {
            paramIndex = parameters.size();
            parameters.add(var);
            selectorName = paramIndex == 0 ? "" : var.getName();
        }
        OCType type = OCTypeUtils.getExtractExpressionType(var.getType(), this.parentCallable, wasNonConstUsage, isReferenceMode);
        if (type instanceof OCCppReferenceType) {
            isReferenceMode = false;
        }
        OCParameterInfo param = this.handler.addParameter(selectorName, var.getName(), type, paramIndex, isReferenceMode);
        paramsMap.put(var, param);
        param.setUsages(this.analyzer.getVariableUsages(var));
        return param;
    }

    private void handleInputOutputVars() {
        ArrayList<PsiElement> newStatements = new ArrayList<PsiElement>(Arrays.asList(this.elements));
        StringBuilder callBuilder = new StringBuilder();
        ArrayList<OCSymbol> parameters = new ArrayList<OCSymbol>();
        HashMap<OCSymbol, OCParameterInfo> paramsMap = new HashMap<OCSymbol, OCParameterInfo>();
        List<OCSymbol> escapedDeclarators = this.analyzer.getEscapedDeclarators();
        ArrayList<OCType> paramTypes = new ArrayList<OCType>();
        OCReadWriteAccessDetector detector = new OCReadWriteAccessDetector();
        boolean hasReturn = false;
        if (this.hasReturnNodes && this.nonVoidParentReturnType) {
            callBuilder.append("return ");
            this.setReturnType(this.parentReturnType, false, false);
            hasReturn = true;
        }
        for (OCSymbol var : this.analyzer.getInputVariables()) {
            boolean wasDereference = false;
            boolean wasNonConstUsage = false;
            for (PsiReference reference : this.analyzer.getVariableUsages(var)) {
                PsiElement parent;
                PsiElement element = reference.getElement();
                if (element instanceof OCReferenceElement && element.getParent() instanceof OCReferenceExpression && (parent = OCParenthesesUtils.topmostParenthesized((OCExpression)element.getParent()).getParent()) instanceof OCUnaryExpression && ((OCUnaryExpression)parent).isGetAddress()) {
                    wasDereference = true;
                }
                if (detector.getExpressionAccess(element) == ReadWriteAccessDetector.Access.Read && detector.canBeConstReference(element, true)) continue;
                wasNonConstUsage = true;
            }
            OCType varType = var.getType().resolve(this.parentCallable);
            paramTypes.add(varType);
            if (varType.getTerminalType() instanceof OCFunctionType) {
                wasNonConstUsage = true;
            }
            this.addParameter(parameters, paramsMap, var, wasDereference || varType instanceof OCStructType, wasDereference || wasNonConstUsage);
        }
        if (this.firstElement instanceof OCExpression && !(this.firstElement.getParent() instanceof OCExpressionStatement)) {
            OCResolveContext resolveContext;
            OCType expectedType;
            OCType returnType = OCExpectedTypeUtil.getExpressionType((OCExpression)this.firstElement, true);
            if ((returnType.isPointerToID() || returnType.isUnknown()) && (expectedType = OCExpectedTypeUtil.getExpectedType((OCExpression)this.firstElement, resolveContext = OCResolveContext.forPsi(this.firstElement))) != OCUnknownType.INSTANCE) {
                returnType = expectedType.resolve(resolveContext);
            }
            returnType = returnType.cloneWithAliasName(((OCExpression)this.firstElement).findBestTypeName(returnType));
            OCSymbol symbol = this.firstElement instanceof OCReferenceExpression ? ((OCReferenceExpression)this.firstElement).resolveToSymbol() : (this.firstElement instanceof OCQualifiedExpression ? ((OCQualifiedExpression)this.firstElement).resolveToSymbol() : null);
            this.setReturnType(returnType, symbol != null && symbol.isGlobal(), new OCReadWriteAccessDetector().canBeConstReference(this.firstElement, true));
            hasReturn = true;
        }
        if (this.analyzer.getOutputVariables().size() > 0) {
            if (!(this.analyzer.getOutputVariables().size() != 1 || this.firstElement instanceof OCExpression || this.hasReturnNodes && this.nonVoidParentReturnType || hasReturn)) {
                this.handleOneOutputVar(newStatements, callBuilder, paramsMap, escapedDeclarators);
            } else {
                this.handleSeveralOutputVars(newStatements, parameters, paramsMap, escapedDeclarators);
            }
        }
        this.handleOutsideDefinedVariables(newStatements, paramsMap.keySet());
        List<OCTypeParameterSymbol<?>> templateArgs = OCCallableUtil.getDependentTemplateSymbols(new OCFunctionType(OCVoidType.instance(), paramTypes), newStatements, true, true, OCResolveContext.forPsi(this.parentCallable));
        callBuilder.append("f");
        if (!templateArgs.isEmpty()) {
            callBuilder.append("<");
            callBuilder.append(StringUtil.join(templateArgs, arg -> arg.getName(), (String)", "));
            callBuilder.append(">");
        }
        callBuilder.append("(");
        boolean isFirst = true;
        for (OCSymbol parameter : parameters) {
            OCParameterInfo paramInfo = (OCParameterInfo)paramsMap.get(parameter);
            callBuilder.append(isFirst ? "" : ",");
            if (paramInfo.isReferenceMode()) {
                callBuilder.append('&');
            }
            callBuilder.append(parameter.getName());
            isFirst = false;
        }
        if (this.callableKind == OCCallableKind.LAMBDA) {
            this.memberAccessType = this.hasMemberAccess();
            if (this.memberAccessType != null) {
                List existingNames = ContainerUtil.map(parameters, OCSymbol::getName);
                String name = OCNameSuggester.suggestForParameter(existingNames, this.memberAccessType, null, OCResolveContext.forPsi(this.firstElement));
                OCParameterInfo parameter = this.handler.addParameter("", name, this.memberAccessType, parameters.size(), true);
                parameter.setDefaultValue("this");
            }
        }
        callBuilder.append(')').append(this.firstElement instanceof OCExpression ? "" : ";");
        this.handler.getGeneratedInfo().setMethodStatements(newStatements);
        this.handler.getGeneratedInfo().setCallString(callBuilder.toString());
        ArrayList<PsiElement> beforeCallStatements = new ArrayList<PsiElement>();
        ArrayList<PsiElement> afterCallStatements = new ArrayList<PsiElement>();
        this.handleEscapedDeclarators(escapedDeclarators, beforeCallStatements);
        if (this.hasReturnNodes && !this.nonVoidParentReturnType && this.hasStatementsAfter) {
            afterCallStatements.add(OCElementFactory.statementFromText("return;", (PsiElement)this.firstElement.getContainingFile()));
        }
        this.handler.getGeneratedInfo().setAfterCallStatements(afterCallStatements);
        this.handler.getGeneratedInfo().setBeforeCallStatements(beforeCallStatements);
    }

    private void setReturnType(OCType returnType, boolean isNonLocal, boolean canReturnConst) {
        OCResolveContext context = OCResolveContext.forPsi(this.parentCallable);
        if (isNonLocal && OCTypeUtils.isPassableByReference(returnType.resolve(context), false, this.parentCallable)) {
            returnType = OCCppReferenceType.to(canReturnConst ? returnType.cloneWithConstModifier(this.project) : returnType);
        }
        if (returnType instanceof OCArrayType) {
            returnType = OCPointerType.to(returnType.getArrayElementType());
        }
        this.handler.setReturnType(returnType);
        this.generateName(returnType);
    }

    private void generateName(@Nullable OCType returnType) {
        OCResolveContext context = OCResolveContext.forPsi(this.parentCallable);
        OCSymbol symbol = this.parentCallable.getSymbol();
        OCSymbolKind symbolKind = OCSymbolKind.FUNCTION_DECLARATION;
        List<String> forbiddenNames = Collections.emptyList();
        ArrayList<String> names = new ArrayList<String>(OCNameSuggester.suggestForExtractionContext(symbolKind, symbol, this.elements, context, this.project));
        if (returnType != null && !(returnType instanceof OCVoidType)) {
            names.addAll(OCNameSuggester.suggestForType(symbolKind, symbol, returnType, this.firstElement, "get", forbiddenNames, context));
        } else {
            String name = OCUniqueNameGenerator.suggestUniqueName(symbolKind, symbol, context, "foo", this.firstElement, forbiddenNames, this.project);
            if (StringUtil.isNotEmpty((String)name)) {
                names.add(name);
            }
        }
        this.handler.setName(names.isEmpty() ? "" : (String)names.iterator().next());
    }

    private void handleEscapedDeclarators(List<OCSymbol> escapedDeclarators, List<PsiElement> beforeCallStatements) {
        for (OCSymbol symbol : escapedDeclarators) {
            beforeCallStatements.add(OCElementFactory.declarationStatement(symbol.getName(), symbol.getType(), null, this.parentCallable));
        }
    }

    private void handleOneOutputVar(List<PsiElement> newStatements, StringBuilder callBuilder, Map<OCSymbol, OCParameterInfo> paramsMap, List<OCSymbol> escapedDeclarators) {
        OCReferenceElement referenceElement;
        OCSymbol var = this.analyzer.getOutputVariables().get(0);
        OCType varType = OCTypeUtils.decayType(var.getType().resolve(this.firstElement), this.project);
        this.setReturnType(varType, this.analyzer.getInputVariables().contains(var), false);
        if (this.selection.contains(var.getOffset())) {
            callBuilder.append(OCElementFactory.declarationText(var.getName(), varType, this.parentCallable));
            escapedDeclarators.remove(var);
        } else {
            callBuilder.append(var.getName());
        }
        callBuilder.append('=');
        OCReturnStatement returnStmt = (OCReturnStatement)OCElementFactory.statementFromText("return " + var.getName() + ";", (PsiElement)this.firstElement.getContainingFile());
        newStatements.add(returnStmt);
        OCParameterInfo param = paramsMap.get(var);
        if (param != null && (referenceElement = ((OCReferenceExpression)returnStmt.getExpression()).getReferenceElement()) != null) {
            param.getUsages().add(referenceElement.getReference());
        }
    }

    private void handleSeveralOutputVars(List<PsiElement> newStatements, List<OCSymbol> parameters, Map<OCSymbol, OCParameterInfo> paramsMap, List<OCSymbol> escapedDeclarators) {
        int firstStatementIndex = 0;
        for (OCSymbol var : this.analyzer.getOutputVariables()) {
            OCStatement newStatement;
            PsiElement declarator = var.locateDefinition(this.project);
            OCParameterInfo parameterInfo = this.addParameter(parameters, paramsMap, var, true, true);
            if (!(declarator instanceof OCDeclarator) || !escapedDeclarators.contains(var) || (newStatement = this.removeDeclarator((OCDeclarator)declarator, parameterInfo)) == null) continue;
            newStatements.add(firstStatementIndex++, newStatement);
        }
    }

    private void handleOutsideDefinedVariables(List<PsiElement> newStatements, Set<OCSymbol> paramSymbols) {
        for (OCSymbol var : this.analyzer.getWrittenVariables()) {
            if (this.selection.contains(var.getOffset()) || paramSymbols.contains(var)) continue;
            newStatements.add(0, OCElementFactory.declarationStatement(var.getName(), var.getType(), null, this.parentCallable));
        }
    }

    @Nullable
    private OCStatement removeDeclarator(OCDeclarator declarator, OCParameterInfo parameter) {
        OCStatement statement;
        this.handler.getGeneratedInfo().runOnSuccess(() -> OCChangeUtil.delete(declarator), OCUsageRank.neutral);
        if (declarator.getInitializer() != null && (statement = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)declarator, OCStatement.class)) != null) {
            OCStatement assignment = OCElementFactory.statementFromText(declarator.getName() + "= 0;", (PsiElement)this.firstElement.getContainingFile());
            ApplicationManager.getApplication().runWriteAction(() -> {
                OCReferenceElement referenceElement;
                OCAssignmentExpression expression = (OCAssignmentExpression)((OCExpressionStatement)assignment).getExpression();
                OCChangeUtil.replaceHandlingMacros(expression.getSourceExpression(), declarator.getInitializer());
                if (parameter != null && (referenceElement = ((OCReferenceExpression)expression.getReceiverExpression()).getReferenceElement()) != null) {
                    parameter.getUsages().add(referenceElement.getReference());
                }
            });
            return assignment;
        }
        return null;
    }

    @Nullable
    private OCStructType hasMemberAccess() {
        OCResolveContext context = OCResolveContext.forPsi(this.parentCallable);
        if (!(this.parentCallableSymbol instanceof OCFunctionSymbol) || ((OCFunctionSymbol)this.parentCallableSymbol).resolveIsFriendOrStatic(context)) {
            return null;
        }
        final OCSymbolWithQualifiedName parent = ((OCFunctionSymbol)this.parentCallableSymbol).getResolvedOwner(context);
        final Ref memberAccess = new Ref((Object)false);
        if (!(parent instanceof OCStructSymbol)) {
            return null;
        }
        for (PsiElement element : this.elements) {
            element.accept((PsiElementVisitor)new OCRecursiveVisitor(){

                @Override
                public void visitReferenceExpression(OCReferenceExpression expression) {
                    OCSymbolWithQualifiedName symbolWQN;
                    super.visitReferenceExpression(expression);
                    OCSymbol symbol = expression.resolveToSymbol();
                    if (symbol instanceof OCSymbolWithQualifiedName && !(symbolWQN = (OCSymbolWithQualifiedName)symbol).isStatic() && OCCodeInsightUtil.isMemberAccess(symbolWQN, (OCStructSymbol)parent, expression)) {
                        memberAccess.set((Object)true);
                    }
                }
            });
        }
        if (!((Boolean)memberAccess.get()).booleanValue()) {
            return null;
        }
        OCStructType type = ((OCStructSymbol)parent).getType();
        if (((OCFunctionSymbol)this.parentCallableSymbol).isConst()) {
            type = (OCStructType)type.cloneWithConstModifier(this.project);
        }
        return type;
    }

    private boolean canBeConst() {
        OCResolveContext context = OCResolveContext.forPsi(this.parentCallable);
        if (!(this.parentCallableSymbol instanceof OCFunctionSymbol) || ((OCFunctionSymbol)this.parentCallableSymbol).resolveIsFriendOrStatic(context)) {
            return false;
        }
        final OCSymbolWithQualifiedName parent = ((OCFunctionSymbol)this.parentCallableSymbol).getResolvedOwner(context);
        if (!(parent instanceof OCStructSymbol)) {
            return false;
        }
        final Ref canBeConst = new Ref((Object)true);
        for (PsiElement element : this.elements) {
            element.accept((PsiElementVisitor)new OCRecursiveVisitor(){

                @Override
                public void visitQualifiedExpression(OCQualifiedExpression expression) {
                    super.visitQualifiedExpression(expression);
                    this.check(expression);
                }

                @Override
                public void visitReferenceExpression(OCReferenceExpression expression) {
                    super.visitReferenceExpression(expression);
                    this.check(expression);
                }

                @Override
                public void visitArraySelectionExpression(OCArraySelectionExpression expression) {
                    super.visitArraySelectionExpression(expression);
                    this.check(expression);
                }

                @Override
                public void visitExpression(OCExpression expr) {
                    super.visitExpression(expr);
                    PsiReference reference = expr.getReference();
                    if (reference instanceof OCOperatorReference) {
                        OCSymbol operator = (OCSymbol)ContainerUtil.getFirstItem(((OCOperatorReference)reference).resolveToSymbols());
                        OCTypeOwner firstArg = (OCTypeOwner)ContainerUtil.getFirstItem(((OCOperatorReference)reference).getArgumentExpressions());
                        if (operator instanceof OCFunctionSymbol && firstArg instanceof OCExpression) {
                            this.checkFunctionCall((OCExpression)firstArg, (OCFunctionSymbol)operator);
                        }
                    }
                }

                @Override
                public void visitCallExpression(OCCallExpression expression) {
                    super.visitCallExpression(expression);
                    OCExpression referenceExpression = expression.getFunctionReferenceExpression();
                    OCSymbol functionSymbol = OCGetSymbolVisitor.getSymbol(referenceExpression);
                    if (functionSymbol instanceof OCFunctionSymbol) {
                        this.checkFunctionCall(referenceExpression, (OCSymbolWithQualifiedName)functionSymbol);
                    }
                }

                @Override
                public void visitForeachStatement(OCForeachStatement statement) {
                    super.visitForeachStatement(statement);
                    OCExpression qualifier = this.getTopmostQualifier(statement.getCollectionExpression());
                    OCSymbol qualifierSymbol = OCGetSymbolVisitor.getSymbol(qualifier);
                    if (qualifierSymbol instanceof OCDeclaratorSymbol && OCCodeInsightUtil.isMemberAccess((OCSymbolWithQualifiedName)qualifierSymbol, (OCStructSymbol)parent, qualifier) && !((OCDeclaratorSymbol)qualifierSymbol).isConst()) {
                        canBeConst.set((Object)false);
                    }
                }

                private void checkFunctionCall(@NotNull OCExpression referenceExpression, @NotNull OCSymbolWithQualifiedName functionSymbol) {
                    OCFunctionSymbol funSymbol;
                    OCResolveContext context = OCResolveContext.forPsi(referenceExpression);
                    OCExpression qualifier = this.getTopmostQualifier(referenceExpression);
                    OCSymbol qualifierSymbol = OCGetSymbolVisitor.getSymbol(qualifier);
                    if (!(!OCCodeInsightUtil.isMemberAccess(functionSymbol, (OCStructSymbol)parent, referenceExpression) || (funSymbol = (OCFunctionSymbol)functionSymbol).isConst() || funSymbol.isCppConstructor() || funSymbol.resolveIsFriendOrStatic(context) || funSymbol.isCppNonMemberOperator(context))) {
                        canBeConst.set((Object)false);
                    }
                    if (qualifierSymbol instanceof OCDeclaratorSymbol && OCCodeInsightUtil.isMemberAccess((OCSymbolWithQualifiedName)qualifierSymbol, (OCStructSymbol)parent, qualifier) && !((OCDeclaratorSymbol)qualifierSymbol).isConst() && !functionSymbol.isConst()) {
                        canBeConst.set((Object)false);
                    }
                }

                private void check(OCExpression expression) {
                    OCExpression qualifier = this.getTopmostQualifier(expression);
                    OCSymbol symbol = OCGetSymbolVisitor.getSymbol(qualifier);
                    if (new OCReadWriteAccessDetector().getExpressionAccess(expression) != ReadWriteAccessDetector.Access.Read && symbol instanceof OCDeclaratorSymbol && OCCodeInsightUtil.isNonStaticFieldAccess((OCDeclaratorSymbol)symbol, (OCStructSymbol)parent, qualifier)) {
                        canBeConst.set((Object)false);
                    }
                }

                private OCExpression getTopmostQualifier(OCExpression referenceExpression) {
                    OCExpression qualifier = OCParenthesesUtils.diveIntoParenthesesAndCasts(referenceExpression);
                    while (qualifier instanceof OCQualifiedExpression || qualifier instanceof OCArraySelectionExpression) {
                        qualifier = qualifier instanceof OCQualifiedExpression ? ((OCQualifiedExpression)qualifier).getQualifier() : ((OCArraySelectionExpression)qualifier).getArrayExpression();
                        qualifier = OCParenthesesUtils.diveIntoParenthesesAndCasts(qualifier);
                    }
                    return qualifier;
                }
            });
        }
        return (Boolean)canBeConst.get();
    }

    private void prepareBlockParameter() {
        this.handler.setNameVisible(true);
        OCCodeMoveValidator validator = new OCCodeMoveValidator(null);
        for (PsiElement element : this.elements) {
            element.accept((PsiElementVisitor)validator);
        }
        if (this.parentCallableSymbol instanceof OCMethodSymbol && !((OCMethodSymbol)this.parentCallableSymbol).isStatic() && validator.isOutOfScope() && ContainerUtil.exists(this.getParentMethodUsages(), info -> {
            PsiElement element = info.getElement();
            if (!(info instanceof OCMethodCallUsage) || !(element instanceof OCSendMessageExpression)) {
                return false;
            }
            OCExpression receiver = ((OCSendMessageExpression)element).getReceiverExpression();
            return !(receiver instanceof OCReferenceExpression) || ((OCReferenceExpression)receiver).getSelfSuperToken() == null;
        })) {
            this.handler.addSelfParameter(((OCMethodSymbol)this.parentCallableSymbol).getParent().getName());
        }
    }

    private void extractLambdaParameter(OCExpression lambda, OCChangeSignatureHandler lambdaHandler) {
        SmartPsiElementPointer lambdaPtr = SmartPointerManager.getInstance((Project)this.project).createSmartPsiElementPointer((PsiElement)lambda);
        String blockName = this.handler.getChangeInfo().getNewName();
        OCType type = lambda.getResolvedType();
        if (lambda instanceof OCLambdaExpression) {
            OCQualifiedNameWithArguments name = new OCQualifiedNameWithArguments(OCQualifiedName.with(OCQualifiedName.interned("std"), "function"), Collections.singletonList(type.getTerminalType()));
            OCSymbolReference.LocalReference reference = OCSymbolReference.getLocalReference(name, (PsiElement)lambda);
            OCReferenceTypeSimple refType = new OCReferenceTypeSimple(reference, false, false, null, false, false);
            type = OCCppReferenceType.to(refType.resolve(lambda).cloneWithAliasName(null), false, true, false);
        }
        OCParameterInfo parameterInfo = lambdaHandler.addParameter("withBlock", blockName, type, -1, false);
        parameterInfo.setDefaultValuePsi((SmartPsiElementPointer<OCExpression>)lambdaPtr);
        if (this.memberAccessType != null) {
            parameterInfo.setLambdaWithParentType(true);
        }
        lambdaHandler.invokeSynchronously(false);
        this.handler.getChangeInfo().setNewMethod(lambdaHandler.getChangeInfo().getMethod());
        OCExpression lambdaElement = (OCExpression)lambdaPtr.getElement();
        if (lambdaElement != null) {
            OCChangeUtil.replaceHandlingMacros(lambdaElement, OCElementFactory.expressionFromText(blockName, lambdaElement));
        } else {
            Segment range = lambdaPtr.getPsiRange();
            PsiFile file = lambdaPtr.getContainingFile();
            if (file != null && range != null) {
                OCChangeUtil.changeText(this.project, file, range.getStartOffset(), range.getEndOffset() - range.getStartOffset(), blockName, false);
            }
        }
    }

    private List<UsageInfo> getParentMethodUsages() {
        HashSet methodUsages = new HashSet();
        OCSearchUtil.findAllMemberUsages((OCSymbolWithParent)this.parentCallableSymbol, methodUsages, true, true, this.project);
        return ContainerUtil.filter(methodUsages, info -> {
            PsiElement usageElement = info.getElement();
            return info instanceof OCMethodCallUsage || info instanceof OCFunctionUsage && usageElement instanceof OCReferenceElement && usageElement.getParent().getParent() instanceof OCCallExpression || info instanceof OCFunctionUsage && usageElement instanceof OCQualifiedExpression && usageElement.getParent() instanceof OCCallExpression || info instanceof OCFunctionUsage && usageElement instanceof OCDeclarator;
        });
    }

    @Nullable
    @NlsContexts.DialogMessage
    private String checkValidity() {
        if (!OCSearchScope.isInProjectSources(this.firstElement)) {
            return RefactoringBundle.message((String)"error.out.of.project.element.default");
        }
        OCDataFlowAnalyzer selectionAnalyzer = new OCDataFlowAnalyzer(this.elements, null);
        selectionAnalyzer.buildControlFlowGraph();
        OCUnreachableCodeFinder finder = selectionAnalyzer.getUnreachableCodeFinder();
        this.hasReturnNodes = finder.isReturnReached();
        if (this.analyzer.hasCrossSelectionJumps() || selectionAnalyzer.hasDanglingJumps() || finder.isDeadEndReached() && this.hasReturnNodes && this.hasStatementsAfter) {
            return OCRefactoringBundle.message("dialog.message.cannot.extract.there.are.multiple.exit.points.in.selected.code.fragment", StringUtil.toLowerCase((String)this.callableKind.toString()));
        }
        if (this.callableKind == OCCallableKind.BLOCK || this.callableKind == OCCallableKind.LAMBDA) {
            List<OCDeclarator> parameters;
            OCType type;
            if (this.parentCallable instanceof OCBlockExpression || this.parentCallable instanceof OCLambdaExpression) {
                return OCRefactoringBundle.message("dialog.message.selected.statements.should.be.inside.function.choice.or.method", this.parentCallable.getContainingOCFile().getKind().isObjC() ? 0 : 1);
            }
            if (this.firstElement instanceof OCCompoundInitializer) {
                return OCRefactoringBundle.message("dialog.message.lambdas.cant.extract.initializer.list", new Object[0]);
            }
            if (this.firstElement instanceof OCExpression && (type = ((OCExpression)this.firstElement).getResolvedType(OCResolveContext.forPsi(this.firstElement))) instanceof OCFunctionType) {
                return OCRefactoringBundle.message("dialog.message.lambdas.cant.extract.functional.type", new Object[0]);
            }
            if (this.parentCallableSymbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)this.parentCallableSymbol).isCppOperator()) {
                return OCRefactoringBundle.message("dialog.message.cant.refactor.operators", new Object[0]);
            }
            if (!OCCallableUtil.getDependentTemplateSymbols(null, Arrays.asList(this.elements), true, false, OCResolveContext.forPsi(this.parentCallable)).isEmpty()) {
                return OCRefactoringBundle.message("dialog.message.lambdas.cant.extract.dependent.types", new Object[0]);
            }
            List<OCDeclarator> list = parameters = this.parentCallable instanceof OCFunctionDeclaration ? ((OCFunctionDeclaration)this.parentCallable).getParameters() : null;
            if (parameters != null && ContainerUtil.exists(parameters, p -> p.getInitializer() != null)) {
                return OCRefactoringBundle.message("can.t.introduce.parameter.to.a.function.with.default.parameter.values", new Object[0]);
            }
        }
        return null;
    }
}

