/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExternalReference;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSelectorExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSynthesizePropertiesList;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.quickfixes.OCReleaseVariablesIntentionAction;
import com.jetbrains.cidr.lang.refactoring.OCUsageViewDescriptor;
import com.jetbrains.cidr.lang.refactoring.util.OCBindUtil;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.refactoring.util.OCElementsMover;
import com.jetbrains.cidr.lang.refactoring.util.OCEscalateVisibilityHelper;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class OCConvertMemberRefactoringProcessor<M extends OCMemberSymbol>
extends BaseRefactoringProcessor {
    private OCClassSymbol myParentClass;
    private List<M> myMembers;
    private Map<M, String> myNewMembersNames;
    private Map<M, OCInstanceVariableSymbol> myNewIvars = new HashMap<M, OCInstanceVariableSymbol>();
    protected Map<M, PsiElement> myNewDeclarations;
    private Map<M, OCMemberSymbol> myExistingDeclarations;
    private List<OCSynthesizePropertiesList> mySynthesizes;
    private OCElementType myNewQualifierType;
    private @NlsContexts.Command String myCommandName;
    private OCReleaseVariablesIntentionAction myReleaseAction;
    private final PsiElement myNewQualifyingToken;
    private Set<M> myMembersWithConflicts = new HashSet<M>();
    private boolean myConvertUsages;

    private OCConvertMemberRefactoringProcessor(OCClassSymbol parentClass, OCElementType newQualifierType, Project project) {
        super(project, EmptyRunnable.INSTANCE);
        this.myParentClass = parentClass;
        this.myNewQualifierType = newQualifierType;
        this.myNewQualifyingToken = OCElementFactory.create(this.myNewQualifierType, this.myParentClass.getContainingOCFile(this.myProject));
    }

    public OCConvertMemberRefactoringProcessor(OCClassSymbol parentClass, List<M> members, Map<M, String> newMemberNames, Map<M, PsiElement> newDeclarations, Map<M, OCMemberSymbol> existingDeclarations, List<OCSynthesizePropertiesList> synthesizes, OCReleaseVariablesIntentionAction releaseAction, OCElementType newQualifierType, @NlsContexts.Command String commandName, boolean convertUsages, Project project) {
        this(parentClass, newQualifierType, project);
        this.myMembers = members;
        this.myNewMembersNames = newMemberNames;
        this.myNewDeclarations = newDeclarations;
        this.myExistingDeclarations = existingDeclarations;
        this.mySynthesizes = synthesizes;
        this.myReleaseAction = releaseAction;
        this.myCommandName = commandName;
        this.myConvertUsages = convertUsages;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        return new OCUsageViewDescriptor(this.myParentClass.locateDefinition(this.myProject), this.getCommandName());
    }

    protected UsageInfo @NotNull [] findUsages() {
        ArrayList<ConvertUsage<OCMemberSymbol>> usages = new ArrayList<ConvertUsage<OCMemberSymbol>>();
        for (OCMemberSymbol member : this.myMembers) {
            PsiElement element = member.locateDefinition(this.myProject);
            String newName = this.myNewMembersNames.get(member);
            OCInstanceVariableSymbolImpl ivar = new OCInstanceVariableSymbolImpl(this.myParentClass.getContainingFile(), Long.MAX_VALUE, newName, Collections.emptyList(), this.myParentClass, member.getType(), OCVisibility.PRIVATE, null);
            this.myNewIvars.put(member, ivar);
            if (element == null || !this.isReplaceMode()) continue;
            for (PsiReference reference : ReferencesSearch.search((PsiElement)element).findAll()) {
                usages.add(new ConvertUsage<OCMemberSymbol>(reference, member));
                PsiElement referenceElement = reference.getElement();
                if (!(member instanceof OCPropertySymbol) || referenceElement == null) continue;
                OCVisibility curVisibility = OCVisibility.getMinimalVisibilityForSymbolToBeAccessible(ivar, referenceElement, null);
                ivar.updateVisibility(OCVisibility.mostVisible(ivar.getVisibility(), curVisibility));
            }
        }
        return usages.toArray(new ConvertUsage[0]);
    }

    private boolean isReplaceMode() {
        return this.mySynthesizes == null;
    }

    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        Arrays.sort(usages, (u1, u2) -> u2.getNavigationOffset() - u1.getNavigationOffset());
        PsiElement classDeclaration = this.myParentClass.locateDefinition(this.myProject);
        OCImplementationSymbol implementation = this.myParentClass.getImplementation(this.myProject);
        PsiElement anInterface = this.myParentClass.getInterface(this.myProject).locateDefinition(this.myProject);
        PsiElement implDeclaration = implementation != null ? implementation.locateDefinition(this.myProject) : null;
        OCElementsMover mover = new OCElementsMover(true);
        ArrayList<PsiElement> elementsToRemove = new ArrayList<PsiElement>();
        HashMap<OCMemberSymbol, PsiElement> existingPsiDeclarations = new HashMap<OCMemberSymbol, PsiElement>();
        HashMap<SmartPsiElementPointer, Pair> elemsToEscalateVisibility = new HashMap<SmartPsiElementPointer, Pair>();
        if (this.isReplaceMode()) {
            for (OCMemberSymbol member : this.myMembers) {
                if (this.myMembersWithConflicts.contains(member)) continue;
                OCMemberSymbol associatedSymbol = member.getAssociatedSymbol(this.myProject);
                elementsToRemove.add(member.locateDefinition(this.myProject));
                elementsToRemove.add(associatedSymbol != null ? associatedSymbol.locateDefinition(this.myProject) : null);
            }
        }
        Iterator<M> iterator2 = this.myMembers.iterator();
        while (iterator2.hasNext()) {
            OCMemberSymbol member;
            OCMemberSymbol existingSymbol = this.myExistingDeclarations.get(member = (OCMemberSymbol)iterator2.next());
            existingPsiDeclarations.put(member, existingSymbol != null ? existingSymbol.locateDefinition(this.myProject) : null);
        }
        for (OCMemberSymbol member : this.myMembers) {
            PsiElement newDeclaration = this.myNewDeclarations.get(member);
            PsiElement existingDecl = (PsiElement)existingPsiDeclarations.get(member);
            OCMemberSymbol existingSymbol = this.myExistingDeclarations.get(member);
            if (member instanceof OCPropertySymbol) {
                OCInstanceVariableSymbol newIvar = this.myNewIvars.get(member);
                if (existingDecl != null) {
                    if (((OCInstanceVariableSymbol)existingSymbol).getVisibility().compareTo(newIvar.getVisibility()) <= 0) continue;
                    SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer(existingDecl);
                    elemsToEscalateVisibility.put(pointer, new Pair((Object)existingSymbol, (Object)newIvar.getVisibility()));
                    continue;
                }
                if (newDeclaration == null) continue;
                OCClassDeclaration parent = (OCClassDeclaration)(newIvar.getVisibility() == OCVisibility.PRIVATE || anInterface == null ? classDeclaration : anInterface);
                this.myNewDeclarations.put(member, mover.addInstanceVariable(parent, newIvar, (OCDeclaration)newDeclaration));
                continue;
            }
            if (existingDecl != null || newDeclaration == null) continue;
            this.myNewDeclarations.put(member, OCChangeUtil.add(classDeclaration, newDeclaration));
        }
        for (UsageInfo usage : usages) {
            PsiElement element = usage.getElement();
            String newSymbolName = this.myNewMembersNames.get(((ConvertUsage)usage).getSymbol());
            this.changeUsage(element, newSymbolName);
        }
        if (implDeclaration != null && this.mySynthesizes != null) {
            for (OCSynthesizePropertiesList synthesize : this.mySynthesizes) {
                OCChangeUtil.add(implDeclaration, synthesize);
            }
        }
        PsiFile file = classDeclaration.getContainingFile();
        for (PsiElement element : elementsToRemove) {
            if (element == null || !element.isValid()) continue;
            OCChangeUtil.delete(element);
        }
        if (this.myReleaseAction != null) {
            Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(file);
            PsiDocumentManager.getInstance((Project)this.myProject).doPostponedOperationsAndUnblockDocument(document);
            OCFile associatedFile = ((OCFile)file).getAssociatedFile();
            if (associatedFile != null) {
                document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument((PsiFile)associatedFile);
                PsiDocumentManager.getInstance((Project)this.myProject).doPostponedOperationsAndUnblockDocument(document);
            }
            this.myReleaseAction.invoke(this.myProject, null, file);
        }
        OCEscalateVisibilityHelper.ALL_ELEMENTS_TO_ESCALATE_VISIBILITY.set((UserDataHolder)this.myProject, elemsToEscalateVisibility);
    }

    protected void performPsiSpoilingRefactoring() {
        OCBindUtil.escalateVisibilities(this.myProject, new VirtualFile[0]);
    }

    private PsiElement changeUsage(PsiElement element, String newSymbolName) {
        if (OCElementUtil.isPartOfMacroSubstitution(element)) {
            return element;
        }
        if (element instanceof OCQualifiedExpression) {
            if (!this.myConvertUsages) {
                ((OCQualifiedExpression)element).setName(newSymbolName);
                return element;
            }
            OCExpression qualifier = ((OCQualifiedExpression)element).getQualifier();
            if (this.myNewQualifierType == OCTokenTypes.DEREF && qualifier instanceof OCReferenceExpression && ((OCReferenceExpression)qualifier).getSelfSuperToken() == OCElementTypes.SelfSuperToken.SELF) {
                return OCChangeUtil.replaceHandlingMacros(element, OCElementFactory.expressionFromText(newSymbolName, element));
            }
            ((OCQualifiedExpression)element).setName(newSymbolName);
            PsiElement qualifyingToken = ((OCQualifiedExpression)element).getQualifyingToken().getPsi();
            OCChangeUtil.replaceHandlingMacros(qualifyingToken, this.myNewQualifyingToken);
            return element;
        }
        if (element instanceof OCReferenceElement) {
            if (!this.myConvertUsages) {
                ((OCReferenceElement)element).setNameOfIdentifier(newSymbolName);
                return element;
            }
            if (element.getParent() instanceof OCSynthesizeProperty) {
                OCChangeUtil.delete(element.getParent());
                return null;
            }
            assert (this.myNewQualifierType == OCTokenTypes.DOT);
            return OCChangeUtil.replaceHandlingMacros(element, OCElementFactory.expressionFromText("self." + newSymbolName, element));
        }
        if (element instanceof OCSendMessageExpression) {
            List<OCExpression> arguments = ((OCSendMessageExpression)element).getArgumentExpressions();
            OCExpression receiver = ((OCSendMessageExpression)element).getReceiverExpression();
            if (arguments.isEmpty()) {
                if (receiver instanceof OCReferenceExpression && ((OCReferenceExpression)receiver).getSelfSuperToken() == OCElementTypes.SelfSuperToken.SELF) {
                    return OCChangeUtil.replaceHandlingMacros(element, OCElementFactory.expressionFromText(newSymbolName, element));
                }
                OCQualifiedExpression expression = (OCQualifiedExpression)OCElementFactory.expressionFromText("a->" + newSymbolName, element);
                OCChangeUtil.replaceHandlingMacros(expression.getQualifier(), receiver);
                return OCChangeUtil.replaceHandlingMacros(element, expression);
            }
            assert (arguments.size() == 1);
            if (receiver instanceof OCReferenceExpression && ((OCReferenceExpression)receiver).getSelfSuperToken() == OCElementTypes.SelfSuperToken.SELF) {
                OCAssignmentExpression expression = (OCAssignmentExpression)OCElementFactory.expressionFromText(newSymbolName + "=a", element);
                OCChangeUtil.replaceHandlingMacros(expression.getSourceExpression(), arguments.get(0));
                return OCChangeUtil.replaceHandlingMacros(element, expression);
            }
            OCAssignmentExpression expression = (OCAssignmentExpression)OCElementFactory.expressionFromText("a->" + newSymbolName + "=a", element);
            OCChangeUtil.replaceHandlingMacros(expression.getSourceExpression(), arguments.get(0));
            OCChangeUtil.replaceHandlingMacros(((OCQualifiedExpression)expression.getReceiverExpression()).getQualifier(), receiver);
            return OCChangeUtil.replaceHandlingMacros(element, expression);
        }
        return null;
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (!this.isReplaceMode()) {
            return super.preprocessUsages(refUsages);
        }
        UsageInfo[] usages = (UsageInfo[])refUsages.get();
        MultiMap conflicts = new MultiMap();
        HashMap<CallSite, PsiElement> uniqueConflicts = new HashMap<CallSite, PsiElement>();
        for (OCMemberSymbol member : this.myMembers) {
            CommonProcessors.FindFirstProcessor accessorFinder = new CommonProcessors.FindFirstProcessor();
            CommonProcessors.FindFirstProcessor overloadFinder = new CommonProcessors.FindFirstProcessor();
            OCCompilationContext compilationContext = OCCompilationContext.create(member, this.myProject);
            if (member instanceof OCPropertySymbol && !((OCPropertySymbol)member).processAccessorMethods((Processor<? super OCMethodSymbol>)accessorFinder, false, this.myProject)) {
                uniqueConflicts.put((CallSite)((Object)(member.getNameWithKindUppercase(compilationContext) + " has custom accessor methods")), ((OCMethodSymbol)accessorFinder.getFoundValue()).locateDefinition(this.myProject));
                this.myMembersWithConflicts.add(member);
            }
            if (member instanceof OCPropertySymbol && !OCSearchUtil.processMembersHierarchy(member, overloadFinder, true, false, false, this.myProject)) {
                uniqueConflicts.put((CallSite)((Object)(member.getNameWithKindUppercase(compilationContext) + " overrides the property from the " + ((OCMemberSymbol)overloadFinder.getFoundValue()).getParent().getNameWithKindLowercase(compilationContext))), ((OCMemberSymbol)overloadFinder.getFoundValue()).locateDefinition(this.myProject));
                this.myMembersWithConflicts.add(member);
                continue;
            }
            if (!(member instanceof OCPropertySymbol) || OCSearchUtil.processMembersHierarchy(member, overloadFinder, false, true, false, this.myProject)) continue;
            uniqueConflicts.put((CallSite)((Object)(member.getNameWithKindUppercase(compilationContext) + " is overridden in the " + ((OCMemberSymbol)overloadFinder.getFoundValue()).getParent().getNameWithKindLowercase(compilationContext))), ((OCMemberSymbol)overloadFinder.getFoundValue()).locateDefinition(this.myProject));
            this.myMembersWithConflicts.add(member);
        }
        for (UsageInfo usage : usages) {
            PsiElement element = usage.getElement();
            Object symbol = ((ConvertUsage)usage).getSymbol();
            OCCompilationContext compilationContext = OCCompilationContext.create(symbol, this.myProject);
            if (element instanceof OCSelectorExpression) {
                uniqueConflicts.put((CallSite)((Object)(symbol.getNameWithKindUppercase(compilationContext) + " has @selector references")), element);
                this.myMembersWithConflicts.add(symbol);
                continue;
            }
            if (usage.getReference() instanceof OCExternalReference) {
                String componentName = ((OCExternalReference)usage.getReference()).getExternalComponentName();
                uniqueConflicts.put((CallSite)((Object)(symbol.getNameWithKindUppercase(compilationContext) + " has " + componentName + " references")), element);
                this.myMembersWithConflicts.add(symbol);
                continue;
            }
            if (element == null || !"Swift".equals(element.getLanguage().getDisplayName())) continue;
            conflicts.putValue((Object)element, (Object)"Property is accessed from Swift");
            this.myMembersWithConflicts.add(symbol);
        }
        for (String string : uniqueConflicts.keySet()) {
            conflicts.putValue((Object)((PsiElement)uniqueConflicts.get(string)), (Object)string);
        }
        return this.showConflicts(conflicts, usages);
    }

    @NotNull
    protected String getCommandName() {
        return this.myCommandName;
    }

    private static class ConvertUsage<M extends OCMemberSymbol>
    extends UsageInfo {
        private M mySymbol;

        ConvertUsage(@NotNull PsiReference reference, M symbol) {
            super(reference);
            this.mySymbol = symbol;
        }

        public M getSymbol() {
            return this.mySymbol;
        }
    }
}

