/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.daemon.OCSuppressionGroup;
import com.jetbrains.cidr.lang.psi.OCFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSuppressClazyCheckForFile
extends SuppressIntentionAction {
    private final String mySuppressOption;

    public OCSuppressClazyCheckForFile(@Nullable OCSuppressionGroup suppressionGroup) {
        this.mySuppressOption = suppressionGroup == null ? null : suppressionGroup.suppressionOption;
    }

    @NotNull
    @IntentionFamilyName
    public String getFamilyName() {
        return OCInspectionsBundle.message("intentions.suppress.for", "file");
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        OCFile file = (OCFile)element.getContainingFile();
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument((PsiFile)file);
        if (document == null) {
            return;
        }
        document.insertString(0, (CharSequence)("// clazy:excludeall=" + this.mySuppressOption.replace("-Wclazy-", "") + "\n"));
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        return element.isValid() && this.mySuppressOption != null;
    }

    @NotNull
    public String getText() {
        return OCInspectionsBundle.message("intentions.suppress.option.for", this.mySuppressOption, "file");
    }
}

