/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.daemon.OCPragmaSuppressionUtils;
import com.jetbrains.cidr.lang.daemon.OCSuppressionGroup;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCPragma;
import com.jetbrains.cidr.lang.quickfixes.OCSuppressClangForCallable;
import com.jetbrains.cidr.lang.quickfixes.OCSuppressClangForFile;
import com.jetbrains.cidr.lang.quickfixes.OCSuppressClangForStatement;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSuppressClangDiagnosticIntentionAction
extends SuppressIntentionAction {
    private final SmartPsiElementPointer<PsiElement> myElementPtr;
    private final String myCompiler;
    private final String mySuppressOption;
    private final String mySuppressScope;

    protected OCSuppressClangDiagnosticIntentionAction(@Nullable PsiElement element, @Nullable OCSuppressionGroup suppressionGroup, String suppressScope) {
        this.myElementPtr = OCElementUtil.createPsiElementPointer(element);
        this.myCompiler = suppressionGroup == null ? null : suppressionGroup.compiler;
        this.mySuppressOption = suppressionGroup == null ? null : suppressionGroup.suppressionOption;
        this.mySuppressScope = suppressScope;
    }

    @NotNull
    public String getFamilyName() {
        return OCInspectionsBundle.message("intentions.suppress.for", this.mySuppressScope);
    }

    @NotNull
    public String getText() {
        return OCInspectionsBundle.message("intentions.suppress.option.for", this.mySuppressOption, this.mySuppressScope);
    }

    @Nullable
    protected TextRange getSuppressionRange(OCFile file) {
        PsiElement element = OCElementUtil.getPsiElementByPointer(this.myElementPtr);
        return element != null ? OCElementUtil.getRangeWithMacros(element) : null;
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) {
        return element.isValid() && this.myElementPtr != null && this.mySuppressOption != null;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        OCFile file = (OCFile)element.getContainingFile();
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument((PsiFile)file);
        int elementOffset = OCElementUtil.getRangeWithMacros(element).getStartOffset();
        TextRange suppressionRange = this.getSuppressionRange(file);
        if (document == null || suppressionRange == null) {
            return;
        }
        if (OCPragmaSuppressionUtils.getDiagnosticMode(file, elementOffset, this.mySuppressOption) == OCPragma.Mode.IGNORE) {
            return;
        }
        int startLine = document.getLineNumber(suppressionRange.getStartOffset());
        int endLine = document.getLineNumber(suppressionRange.getEndOffset());
        if (startLine >= 0 && startLine < document.getLineCount() && endLine >= 0 && endLine < document.getLineCount()) {
            int startOffset = document.getLineStartOffset(startLine);
            int endOffset = document.getLineEndOffset(endLine);
            boolean pushToStack = true;
            if (OCPragmaSuppressionUtils.findExactScope(file, startOffset, endOffset) != null) {
                pushToStack = false;
            }
            if (pushToStack) {
                document.insertString(endOffset, (CharSequence)"\n#pragma clang diagnostic pop");
            }
            document.insertString(startOffset, (CharSequence)("#pragma " + this.myCompiler + " diagnostic ignored \"" + this.mySuppressOption + "\"\n"));
            if (pushToStack) {
                document.insertString(startOffset, (CharSequence)"#pragma clang diagnostic push\n");
            }
            PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(document);
        }
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        return IntentionPreviewInfo.EMPTY;
    }

    public static class SuppressFixForFile
    extends SuppressFix {
        public SuppressFixForFile(@Nullable OCSuppressionGroup suppressionGroup) {
            super(suppressionGroup);
        }

        @Override
        @NotNull
        protected OCSuppressClangDiagnosticIntentionAction createFix(PsiElement element) {
            return new OCSuppressClangForFile(element.getContainingFile(), OCElementUtil.getRangeWithMacros(element), this.mySuppressionGroup);
        }

        @NotNull
        public String getName() {
            return OCInspectionsBundle.message("intentions.suppress.for.file", new Object[0]);
        }
    }

    public static class SuppressFixForCallable
    extends SuppressFix {
        public SuppressFixForCallable(@Nullable OCSuppressionGroup suppressionGroup) {
            super(suppressionGroup);
        }

        @Override
        @NotNull
        protected OCSuppressClangDiagnosticIntentionAction createFix(PsiElement element) {
            return new OCSuppressClangForCallable(element.getContainingFile(), OCElementUtil.getRangeWithMacros(element), this.mySuppressionGroup);
        }

        @NotNull
        public String getName() {
            return OCInspectionsBundle.message("intentions.suppress.for.method", new Object[0]);
        }
    }

    public static class SuppressFixForStatement
    extends SuppressFix {
        public SuppressFixForStatement(@Nullable OCSuppressionGroup suppressionGroup) {
            super(suppressionGroup);
        }

        @Override
        @NotNull
        protected OCSuppressClangDiagnosticIntentionAction createFix(PsiElement element) {
            return new OCSuppressClangForStatement(element.getContainingFile(), OCElementUtil.getRangeWithMacros(element), this.mySuppressionGroup);
        }

        @NotNull
        public String getName() {
            return OCInspectionsBundle.message("intentions.suppress.for.statement", new Object[0]);
        }
    }

    private static abstract class SuppressFix
    implements SuppressQuickFix {
        @Nullable
        protected OCSuppressionGroup mySuppressionGroup;

        protected SuppressFix(@Nullable OCSuppressionGroup suppressionGroup) {
            this.mySuppressionGroup = suppressionGroup;
        }

        @NotNull
        protected abstract OCSuppressClangDiagnosticIntentionAction createFix(PsiElement var1);

        public boolean isAvailable(@NotNull Project project, @NotNull PsiElement context) {
            return this.createFix(context).isAvailable(project, null, context);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            this.createFix(descriptor.getPsiElement()).invoke(project, null, descriptor.getPsiElement());
        }

        public boolean isSuppressAll() {
            return false;
        }
    }
}

