/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCElementsMover;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSetSuperclassIntentionAction
extends OCSymbolQuickFix<OCSymbol> {
    private final OCSymbol mySuperClass;
    private final OCVisibility myVisibility;
    @IntentionName
    private final String myText;

    public OCSetSuperclassIntentionAction(@NotNull OCSymbol classSymbol, OCSymbol superClass, @Nullable OCVisibility visibility, @NotNull OCCompilationContext context) {
        super(context.getProject(), classSymbol);
        this.mySuperClass = superClass;
        this.myVisibility = visibility;
        this.myText = this.getTextImpl(context);
    }

    @Override
    protected String getTextInternal() {
        return this.myText;
    }

    @IntentionName
    private String getTextImpl(@NotNull OCCompilationContext context) {
        String superTypeName;
        if (this.mySymbol instanceof OCInterfaceSymbol && !(superTypeName = ((OCInterfaceSymbol)this.mySymbol).getSuperClassName()).isEmpty() && this.mySuperClass != null) {
            return OCInspectionsBundle.message("intention.name.change.superclass", this.mySymbol.getNameWithKindLowercase(context), superTypeName, this.mySuperClass.getPresentableName());
        }
        assert (this.mySuperClass != null);
        String subject = OCInspectionsBundle.message("intention.name.choice.superclass", this.myVisibility != null ? this.myVisibility.toString() : "", this.myVisibility != null ? 0 : 1, this.mySymbol.getNameWithKindLowercase(context));
        return OCInspectionsBundle.message("intention.name.set.superclass", this.mySuperClass.getPresentableName(), subject);
    }

    @NotNull
    public String getFamilyName() {
        return OCInspectionsBundle.message("intentions.change.superclass", new Object[0]);
    }

    @Override
    public boolean isAvailable() {
        return !(!super.isAvailable() || this.mySymbol.isPredeclaration() || !(this.mySymbol instanceof OCInterfaceSymbol) && !(this.mySymbol instanceof OCStructSymbol) || !(this.mySuperClass instanceof OCInterfaceSymbol) && !(this.mySuperClass instanceof OCStructSymbol));
    }

    @Override
    protected void invoke(@NotNull Project project, Editor editor) {
        OCSymbolDeclarator declaration = (OCSymbolDeclarator)this.mySymbol.locateDefinition(project);
        if (this.mySuperClass instanceof OCInterfaceSymbol) {
            if (declaration != null) {
                new OCElementsMover().setSuperClass((OCClassDeclaration)declaration, this.mySuperClass.getName());
            }
        } else {
            new OCElementsMover().removeBaseClass((OCStruct)declaration, (OCStructSymbol)this.mySuperClass, false);
            new OCElementsMover().addBaseClass((OCStruct)declaration, (OCStructSymbol)this.mySuperClass, this.myVisibility, false);
        }
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        PsiElement declaration = this.mySymbol.locateDefinition(project);
        if (!(declaration instanceof OCStruct)) {
            return IntentionPreviewInfo.EMPTY;
        }
        OCStruct struct = (OCStruct)declaration;
        OCSymbolKind symbolKind = struct.getKind();
        String keyword = symbolKind.getStructKeyword();
        return new IntentionPreviewInfo.CustomDiff(file.getFileType(), keyword + " " + struct.getName(), keyword + " " + struct.getName() + " : " + this.myVisibility + " " + this.mySuperClass.getName());
    }
}

