/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import org.jetbrains.annotations.NotNull;

public class OCSendMessageToObjectIntentionAction
extends OCPsiElementQuickFix<PsiElement> {
    private final String myMessage;

    public OCSendMessageToObjectIntentionAction(@NotNull PsiElement object, String message) {
        super(object);
        this.myMessage = message;
    }

    @Override
    @IntentionFamilyName
    protected String getTextInternal() {
        return OCInspectionsBundle.message("intention.family.name.send.message", this.myMessage);
    }

    @NotNull
    public String getFamilyName() {
        return this.getTextInternal();
    }

    @Override
    protected void invoke(PsiFile file, @NotNull PsiElement object) {
        OCSendMessageExpression call = (OCSendMessageExpression)OCElementFactory.expressionFromText("[x " + this.myMessage + "]", (PsiElement)file);
        call.getReceiverExpression().replace(object);
        OCChangeUtil.replaceHandlingMacros(object, call);
    }
}

