/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.refactoring.rename.OCInplaceRenameHandler;
import com.jetbrains.cidr.lang.refactoring.rename.OCInplaceRenamer;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import org.jetbrains.annotations.NotNull;

public class OCRenameSymbolIntentionAction
extends OCSymbolQuickFix<OCSymbol>
implements HighPriorityAction {
    @IntentionName
    private final String myText;

    public OCRenameSymbolIntentionAction(@NotNull OCSymbol symbol, @NotNull OCCompilationContext context) {
        super(context.getProject(), symbol);
        this.myText = OCInspectionsBundle.message("intention.name.rename", this.mySymbol.getNameWithKindLowercase(context));
    }

    @Override
    protected String getTextInternal() {
        return this.myText;
    }

    @NotNull
    public String getFamilyName() {
        return OCInspectionsBundle.message("intentions.rename.symbol", new Object[0]);
    }

    @Override
    protected void invoke(@NotNull Project project, Editor editor) {
        OCInplaceRenamer renamer;
        PsiElement element;
        if (editor != null && (element = this.mySymbol.locateDefinition(project)) != null && (renamer = (OCInplaceRenamer)new OCInplaceRenameHandler().createRenamer(element, editor)) != null) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                renamer.performRenameInner(element, "renamed");
            } else {
                renamer.performInplaceRename();
            }
        }
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        return IntentionPreviewInfo.EMPTY;
    }
}

