/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCType;
import org.jetbrains.annotations.NotNull;

public class OCRemoveInitializerIntentionAction
extends OCPsiElementQuickFix<OCDeclarator> {
    public OCRemoveInitializerIntentionAction(@NotNull OCDeclarator declarator) {
        super(declarator);
    }

    public static boolean canRemoveInitializer(@NotNull OCDeclarator declarator) {
        PsiElement declaration = declarator.getParent();
        if (declaration instanceof OCDeclaration) {
            OCType declarationType = ((OCDeclaration)declaration).getType();
            return !(declarationType instanceof OCAutoType);
        }
        return true;
    }

    @Override
    @IntentionFamilyName
    protected String getTextInternal() {
        return OCInspectionsBundle.message("intention.family.name.remove.initializer", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getTextInternal();
    }

    @Override
    protected boolean isAvailable(@NotNull OCDeclarator declarator) {
        PsiElement parent = declarator.getParent();
        return declarator.getInitializer() != null && OCRemoveInitializerIntentionAction.canRemoveInitializer(declarator);
    }

    @Override
    protected void invoke(PsiFile file, @NotNull OCDeclarator declarator) {
        OCChangeUtil.delete(declarator.getInitializer());
    }
}

