/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import org.jetbrains.annotations.NotNull;

public class OCMakeFunctionVirtualFix
extends OCSymbolQuickFix<OCFunctionSymbol> {
    private final boolean isPure;
    private final boolean supportsConstexprVirtual;

    public OCMakeFunctionVirtualFix(@NotNull OCFunctionSymbol symbol, boolean pure, @NotNull Project project) {
        super(project, symbol);
        this.isPure = pure;
        PsiFile file = symbol.getContainingPsiFile(project);
        this.supportsConstexprVirtual = OCCompilerFeaturesHelper.supportsConstexprVirtual(file);
    }

    @Override
    public boolean isAvailable() {
        boolean isConstexprConsteval;
        boolean bl = isConstexprConsteval = ((OCFunctionSymbol)this.mySymbol).isConstexpr() || ((OCFunctionSymbol)this.mySymbol).isConsteval();
        if (isConstexprConsteval && !this.supportsConstexprVirtual) {
            return false;
        }
        return super.isAvailable() && ((OCFunctionSymbol)this.mySymbol).getParent() != null && !((OCFunctionSymbol)this.mySymbol).isCppConstructor() && !((OCFunctionSymbol)this.mySymbol).isFriendOrStatic() && !((OCFunctionSymbol)this.mySymbol).isTemplateSymbol();
    }

    @Override
    protected String getTextInternal() {
        return OCInspectionsBundle.message("intention.name.make.function.virtual", ((OCFunctionSymbol)this.mySymbol).getParent().getName(), ((OCFunctionSymbol)this.mySymbol).getName(), this.isPure ? 0 : 1);
    }

    @NotNull
    public String getFamilyName() {
        return OCBundle.message("quickfixes.make.function.virtual", new Object[0]);
    }

    @Override
    protected void invoke(@NotNull Project project, Editor editor) {
        OCFunctionDeclaration function = ((OCFunctionSymbol)this.mySymbol).locateFunctionDefinition(project);
        if (function != null) {
            int offset;
            if (this.isPure) {
                offset = function.getDeclarator().getTextRange().getEndOffset();
                OCChangeUtil.changeText(function.getProject(), function.getContainingFile(), offset, 0, "= 0", true);
            }
            if (!((OCFunctionSymbol)this.mySymbol).isVirtual()) {
                offset = function.getTextRange().getStartOffset();
                OCChangeUtil.changeText(function.getProject(), function.getContainingFile(), offset, 0, "virtual ", true);
            }
        }
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        String oldSignature = OCElementUtil.getSignature((OCFunctionSymbol)this.mySymbol, project);
        if (StringUtil.isEmpty((String)oldSignature)) {
            return IntentionPreviewInfo.EMPTY;
        }
        StringBuilder builder2 = new StringBuilder();
        if (!((OCFunctionSymbol)this.mySymbol).isVirtual()) {
            builder2.append("virtual ");
        }
        builder2.append(oldSignature);
        if (this.isPure) {
            builder2.append("= 0");
        }
        return new IntentionPreviewInfo.CustomDiff(file.getFileType(), oldSignature, builder2.toString());
    }
}

