/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.inspections.OCInspectionUtil;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCLoopStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCExtractAssignmentIntentionAction
extends OCPsiElementQuickFix<OCExpression> {
    private final SmartPsiElementPointer<?> myLeftOperandPtr;

    public OCExtractAssignmentIntentionAction(OCExpression expression, OCExpression leftOperand) {
        super(expression);
        this.myLeftOperandPtr = OCElementUtil.createPsiElementPointer(leftOperand);
    }

    @Override
    @IntentionFamilyName
    protected String getTextInternal() {
        return OCInspectionsBundle.message("intention.family.name.extract.assignment", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getTextInternal();
    }

    @Override
    protected boolean isAvailable(@NotNull OCExpression expression) {
        OCStatement condStatement = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, OCStatement.class);
        return !(condStatement instanceof OCLoopStatement) || OCExtractAssignmentIntentionAction.getLoopBlock(expression) != null;
    }

    @Override
    protected void invoke(PsiFile file, @NotNull OCExpression expression) {
        OCStatement condStatement = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, OCStatement.class);
        if (condStatement == null) {
            return;
        }
        OCBlockStatement loopBlock = OCExtractAssignmentIntentionAction.getLoopBlock(expression);
        OCExpressionStatement statement = (OCExpressionStatement)OCElementFactory.statementFromText("1;", (PsiElement)file);
        statement.getExpression().replace(expression);
        expression.replace((PsiElement)OCElementUtil.getPsiElementByPointer(this.myLeftOperandPtr));
        if (loopBlock != null) {
            OCChangeUtil.add(loopBlock, statement.copy());
        }
        condStatement = OCChangeUtil.ensureParentIsBlockStatement(condStatement);
        OCChangeUtil.addBefore(condStatement.getParent(), statement, condStatement);
    }

    @Nullable
    private static OCBlockStatement getLoopBlock(OCExpression expression) {
        OCStatement condStatement = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, OCStatement.class);
        if (condStatement instanceof OCLoopStatement) {
            OCStatement body = ((OCLoopStatement)condStatement).getBody();
            return body instanceof OCBlockStatement ? (OCBlockStatement)body : null;
        }
        return null;
    }

    @Override
    protected boolean shouldCommitAllDocuments() {
        return false;
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        PsiElement expressionElementCopy = OCInspectionUtil.findSameElementInCopy((SmartPsiElementPointer)this.myElementPtr, (PsiFile)target);
        PsiElement leftOperandCopy = OCInspectionUtil.findSameElementInCopy(this.myLeftOperandPtr, (PsiFile)target);
        if (!(expressionElementCopy instanceof OCExpression) || !(leftOperandCopy instanceof OCExpression)) {
            return null;
        }
        return new OCExtractAssignmentIntentionAction((OCExpression)expressionElementCopy, (OCExpression)leftOperandCopy);
    }
}

