/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileActionBase;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import icons.CidrLangIcons;
import org.jetbrains.annotations.NotNull;

public class OCCreateInterfaceIntentionAction
extends OCNewFileActionBase
implements IntentionAction {
    private final OCImplementationSymbol myImplementation;
    @NotNull
    private final PsiElement myImplNameIdentifier;

    public OCCreateInterfaceIntentionAction(OCImplementationSymbol anImplementation, @NotNull PsiElement implNameIdentifier) {
        super((FileType)OCFileType.INSTANCE, OCBundle.message("create.interface.title", new Object[0]), OCBundle.message("create.interface.description", new Object[0]), CidrLangIcons.CodeAssistantClass);
        this.myImplementation = anImplementation;
        this.myImplNameIdentifier = implNameIdentifier;
    }

    @NotNull
    public String getText() {
        if (this.myImplementation == null) {
            return OCBundle.message("action.invalid.title", new Object[0]);
        }
        OCCompilationContext context = OCCompilationContext.create(this.myImplementation, this.myImplNameIdentifier.getProject());
        return OCInspectionsBundle.message("intentions.create.interface", this.myImplementation.getNameWithKindLowercase(context));
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @NotNull
    protected String getDefaultName() {
        return "Interface";
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return super.isAvailable() && OCSearchScope.isInProjectSources(this.myImplementation, project);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        this.addAuxAction(createdElements -> {
            OCInterfaceSymbol interfaceSymbol = this.myImplementation.getInterface(true, this.myImplementation.getCategoryName(), project);
            new OCImportSymbolFix(this.myImplNameIdentifier, interfaceSymbol).fixBestItem(project, file);
            OCImportSymbolFix.fixAllSymbolsRecursively(this.myImplNameIdentifier);
        });
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.performAction(project, file.getParent(), file, this.myImplementation.getName());
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    protected String getFileTemplate(String fileName) {
        return "Objective-C Header File.h";
    }

    @NotNull
    protected OCNewFileActionBase.NewFileNames getNewFileNames(String selectedName) {
        return new OCNewFileActionBase.NewFileNames(null, selectedName + ".h");
    }

    @NotNull
    protected CreateInterfaceDialog createDialog(@NotNull @NlsContexts.Label String defaultName) {
        return new CreateInterfaceDialog(defaultName);
    }

    protected class CreateInterfaceDialog
    extends OCNewFileActionBase.CreateFileDialogBase {
        public CreateInterfaceDialog(String defaultName) {
            super((OCNewFileActionBase)OCCreateInterfaceIntentionAction.this, OCCreateInterfaceIntentionAction.this.getText(), defaultName, null);
        }
    }
}

