/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCCreateDefinitionIntentionAction
implements IntentionAction {
    protected OCSymbolKind mySymbolKind;
    @NotNull
    protected PsiElement myUsage;
    @NotNull
    protected final Project myProject;
    protected OCSymbol myParent;

    public OCCreateDefinitionIntentionAction(OCSymbolKind symbolKind, @NotNull PsiElement usage, OCSymbol parent) {
        this.mySymbolKind = symbolKind;
        this.myUsage = usage;
        this.myProject = usage.getProject();
        this.myParent = parent;
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (!OCCodeInsightUtil.isValid(this.myUsage) || this.myParent != null && !OCSearchScope.isInProjectSources(this.myParent, project)) {
            return false;
        }
        return switch (this.mySymbolKind) {
            case OCSymbolKind.FUNCTION_DECLARATION, OCSymbolKind.METHOD, OCSymbolKind.GLOBAL_VARIABLE, OCSymbolKind.LOCAL_VARIABLE, OCSymbolKind.PROPERTY, OCSymbolKind.MACRO -> true;
            case OCSymbolKind.STRUCT_FIELD -> {
                if (this.myParent != null) {
                    yield true;
                }
                yield false;
            }
            case OCSymbolKind.ENUM_CONST -> {
                if (this.myParent != null && this.myParent.getKind() == OCSymbolKind.ENUM) {
                    yield true;
                }
                yield false;
            }
            case OCSymbolKind.INSTANCE_VARIABLE -> {
                OCMethod method = (OCMethod)PsiTreeUtil.getParentOfType((PsiElement)this.myUsage, OCMethod.class);
                if (method == null || this.myUsage instanceof OCQualifiedExpression || method.isInstanceMethod()) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    @Nullable
    protected abstract PsiElement getDefinition(Project var1, Editor var2, PsiFile var3);

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        ArrayList<PsiFile> filesToWrite = new ArrayList<PsiFile>();
        filesToWrite.add(file);
        if (this.mySymbolKind == OCSymbolKind.STRUCT_FIELD || this.mySymbolKind == OCSymbolKind.ENUM_CONST) {
            filesToWrite.add(this.myParent.getContainingOCFile(project));
        }
        if (FileModificationService.getInstance().preparePsiElementsForWrite(filesToWrite)) {
            this.doCreate(project, editor, file);
        }
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        PsiElement definition = this.getDefinition(project, editor, file);
        return definition != null ? new IntentionPreviewInfo.CustomDiff(file.getFileType(), "", definition.getText()) : IntentionPreviewInfo.EMPTY;
    }

    protected boolean doCreate(Project project, Editor editor, PsiFile file) {
        PsiElement result;
        PsiElement parentElement = this.myParent != null ? this.myParent.locateDefinition(project) : null;
        PsiElement definition = this.getDefinition(project, editor, file);
        if (definition == null) {
            return false;
        }
        if (this.mySymbolKind == OCSymbolKind.FUNCTION_DECLARATION || this.mySymbolKind == OCSymbolKind.METHOD || this.mySymbolKind == OCSymbolKind.GLOBAL_VARIABLE || this.mySymbolKind == OCSymbolKind.LOCAL_VARIABLE || this.mySymbolKind == OCSymbolKind.MACRO || this.mySymbolKind == OCSymbolKind.ENUM_CONST && this.myParent != null) {
            PsiElement parent = this.myParent != null ? this.myParent.locateDefinition(project) : OCChangeUtil.getAppropriateParent(this.mySymbolKind, this.myUsage);
            if (parent == null) {
                return false;
            }
            result = OCChangeUtil.addBefore(parent, definition, this.myUsage);
            OCChangeUtil.addNewLineIfNeed(result, true);
        } else if (this.mySymbolKind == OCSymbolKind.STRUCT_FIELD || this.mySymbolKind == OCSymbolKind.PROPERTY) {
            if (this.myParent == null || parentElement == null) {
                return false;
            }
            result = OCChangeUtil.add(parentElement, definition);
        } else if (this.mySymbolKind == OCSymbolKind.INSTANCE_VARIABLE) {
            if (this.myParent == null || parentElement == null) {
                return false;
            }
            result = OCChangeUtil.add(((OCClassDeclaration)parentElement).getInstanceVariablesList(), definition);
        } else {
            return false;
        }
        if (result != null && this.mySymbolKind != OCSymbolKind.FUNCTION_DECLARATION && this.mySymbolKind != OCSymbolKind.METHOD) {
            if (editor != null && this.mySymbolKind == OCSymbolKind.GLOBAL_VARIABLE && definition instanceof OCDeclaration) {
                editor.getCaretModel().moveToOffset(((OCDeclaration)result).getDeclarators().get(0).getTextRange().getEndOffset());
                editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
            } else {
                OCCodeInsightUtil.selectElement(result);
            }
        }
        return true;
    }

    public boolean startInWriteAction() {
        return true;
    }
}

