/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementQuickFix;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCopyElementIntentionAction
extends OCPsiElementQuickFix<PsiElement> {
    @IntentionName
    private final String myIntentionName;
    private final SmartPsiElementPointer<?> mySourceElementPtr;
    @IntentionFamilyName
    private final String myFamilyName;

    public OCCopyElementIntentionAction(@NotNull PsiElement sourceElement, PsiElement destinationElement, @IntentionFamilyName String intentionName) {
        super(destinationElement);
        this.mySourceElementPtr = OCElementUtil.createPsiElementPointer(sourceElement);
        this.myIntentionName = intentionName;
        this.myFamilyName = intentionName;
    }

    @Override
    protected String getTextInternal() {
        return this.myIntentionName;
    }

    @NotNull
    public String getFamilyName() {
        return this.myFamilyName;
    }

    @Override
    protected boolean isAvailable(@NotNull PsiElement destinationElement) {
        return OCElementUtil.getPsiElementByPointer(this.mySourceElementPtr) != null;
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        return this.myElementPtr.getElement();
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiElement destinationElement = this.myElementPtr.getElement();
        Object sourceElement = OCElementUtil.getPsiElementByPointer(this.mySourceElementPtr);
        destinationElement.replace(sourceElement);
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        PsiElement destinationElement = this.myElementPtr.getElement();
        Object sourceElement = OCElementUtil.getPsiElementByPointer(this.mySourceElementPtr);
        if (sourceElement == null || destinationElement == null) {
            return IntentionPreviewInfo.EMPTY;
        }
        return new IntentionPreviewInfo.CustomDiff(file.getFileType(), sourceElement.getText(), destinationElement.getText());
    }
}

