/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.inspections.OCInspectionUtil;
import com.jetbrains.cidr.lang.parser.OCMacroRange;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.types.OCNumericType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCConvertLiteralIntentionAction
extends OCPsiElementQuickFix<OCExpression>
implements HighPriorityAction {
    private final OCType myLeftType;
    private final OCType myRightType;

    public OCConvertLiteralIntentionAction(@NotNull OCExpression expression, OCType leftType, OCType rightType) {
        super(expression);
        this.myLeftType = leftType;
        this.myRightType = rightType;
    }

    @Override
    @IntentionFamilyName
    protected String getTextInternal() {
        return OCInspectionsBundle.message("intention.family.name.convert.literal.type", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getTextInternal();
    }

    @Override
    public boolean isAvailable(@NotNull OCExpression element) {
        OCExpression expression = (OCExpression)this.myElementPtr.getElement();
        if (this.myLeftType == null || this.myRightType == null || !(expression instanceof OCLiteralExpression) || !OCSearchScope.isInProjectSources(expression.getParent())) {
            return false;
        }
        OCMacroRange call = OCElementUtil.getRangeInMacroCall(expression);
        if (call != null && !call.mapsToArguments()) {
            return false;
        }
        boolean isIdOrObject = this.myLeftType.isObjCRootType();
        return (this.myLeftType.isPointerToStringCompatible() || isIdOrObject) && this.myRightType.isPointerToChar() || (this.myLeftType.getName().equals("NSNumber *") || isIdOrObject) && this.myRightType instanceof OCNumericType && OCCompilerFeaturesHelper.supportsObjectLiterals(expression.getContainingOCFile());
    }

    @Override
    protected void invoke(PsiFile file, @NotNull OCExpression expression) {
        OCChangeUtil.changeText(file.getProject(), file, expression.getRangeWithMacros().getStartOffset(), 0, "@", true);
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        PsiElement elementInCopy = OCInspectionUtil.findSameElementInCopy((SmartPsiElementPointer)this.myElementPtr, (PsiFile)target);
        return elementInCopy instanceof OCExpression ? new OCConvertLiteralIntentionAction((OCExpression)elementInCopy, this.myLeftType, this.myRightType) : null;
    }
}

