/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.daemon.OCAnnotatorSink;
import com.jetbrains.cidr.lang.daemon.OCGetSymbolVisitor;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.quickfixes.OCQuickFix;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.refactoring.util.OCNormalizeUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityAfterResolvingVisitor;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCChangeTypeIntentionAction
extends OCQuickFix {
    @NotNull
    private final OCSymbol mySymbol;
    private OCType mySubstitutionType;
    private String mySubject;
    private String myMessageSuffix = "";
    private boolean myReturnTypeMode;
    private boolean myChangeAssociatedSymbol = true;
    private boolean myChangeProperty;
    protected final Project myProject;

    public OCChangeTypeIntentionAction(@NotNull OCSymbol symbol, OCType substitutionType, @NotNull OCCompilationContext context) {
        this.mySymbol = symbol;
        this.mySubstitutionType = substitutionType;
        this.mySubject = this.mySymbol.getNameWithKindLowercase(context);
        this.myProject = context.getProject();
    }

    public OCChangeTypeIntentionAction(@NotNull OCSymbol symbol, OCType substitutionType, boolean returnTypeMode, @NotNull OCCompilationContext context) {
        this(symbol, substitutionType, returnTypeMode, null, context);
    }

    public OCChangeTypeIntentionAction(@NotNull OCSymbol symbol, OCType substitutionType, boolean returnTypeMode, @Nullable String subject, @NotNull OCCompilationContext context) {
        this(symbol, substitutionType, subject, context);
        this.myReturnTypeMode = returnTypeMode;
        if (this.myReturnTypeMode && symbol.getKind().isFunction() && substitutionType.getTerminalType() instanceof OCFunctionType) {
            this.mySubstitutionType = OCPointerType.to(OCVoidType.instance());
        }
    }

    public OCChangeTypeIntentionAction(@NotNull OCSymbol symbol, OCType substitutionType, @Nullable String subject, @NotNull OCCompilationContext context) {
        this(symbol, substitutionType, context);
        if (subject != null) {
            this.mySubject = subject;
        }
    }

    public OCChangeTypeIntentionAction(@NotNull OCSymbol symbol, OCType substitutionType, String messageSuffix, boolean changeAssociatedSymbol, @NotNull OCCompilationContext context) {
        this(symbol, substitutionType, context);
        this.myMessageSuffix = messageSuffix;
        this.myChangeAssociatedSymbol = changeAssociatedSymbol;
    }

    public static void registerChangeTypeFix(@NotNull OCExpression expression, OCType substitutionType, Annotation annotation, OCAnnotatorSink sink) {
        OCGetSymbolVisitor visitor = new OCGetSymbolVisitor(true, OCResolveContext.forPsi(expression));
        expression.accept(visitor);
        OCSymbol symbol = visitor.getSymbol();
        if (symbol != null) {
            boolean returnTypeMode = OCParenthesesUtils.diveIntoParentheses(expression) instanceof OCCallExpression;
            if (!returnTypeMode) {
                substitutionType = OCPointerType.to(substitutionType, visitor.getNumOfDereferences());
            }
            sink.registerQuickFix(annotation, new OCChangeTypeIntentionAction(symbol, substitutionType, returnTypeMode, OCCompilationContext.create(expression)));
        }
    }

    @Override
    protected String getTextInternal() {
        return OCInspectionsBundle.message("intention.name.change.type", this.myReturnTypeMode || this.mySymbol instanceof OCMethodSymbol ? 0 : 1, this.mySubject, this.mySubstitutionType.getName(OCResolveContext.forSymbol(this.mySymbol, this.myProject)), this.myMessageSuffix);
    }

    @NotNull
    public String getFamilyName() {
        return OCInspectionsBundle.message("intentions.change.type", new Object[0]);
    }

    @Override
    public boolean isAvailable() {
        if (!(OCSearchScope.isInProjectSources(this.mySymbol, this.myProject) && (OCCodeInsightUtil.isValid(this.mySymbol.locateDefinition(this.myProject)) || this.mySymbol instanceof OCInstanceVariableSymbol && ((OCInstanceVariableSymbol)this.mySymbol).isClang4ImplicitIvar(this.myProject)))) {
            return false;
        }
        OCType type = this.mySymbol.getType();
        if (this.mySymbol instanceof OCDeclaratorSymbol && type instanceof OCStructType && !((OCStructType)type).isPredeclaration()) {
            return this.mySubstitutionType instanceof OCPointerType && ((OCPointerType)this.mySubstitutionType).getRefType().getName().equals(type.getName());
        }
        if (this.mySymbol instanceof OCFunctionSymbol && type instanceof OCFunctionType && this.mySubstitutionType instanceof OCPointerType && ((OCPointerType)this.mySubstitutionType).getRefType() instanceof OCPointerType) {
            return false;
        }
        if (!(this.mySubstitutionType.isInstanceable() || this.mySymbol.isCallable() && (this.mySubstitutionType instanceof OCFunctionType || this.mySubstitutionType instanceof OCVoidType))) {
            return false;
        }
        return this.myReturnTypeMode || this.mySymbol.getKind() == OCSymbolKind.METHOD || !new OCTypeEqualityAfterResolvingVisitor(this.mySubstitutionType, false, false, false, false, OCResolveContext.forSymbol(this.mySymbol, this.myProject)).equal(type);
    }

    @Override
    protected void invoke(PsiFile file, @NotNull Project project) {
        ArrayList<OCSymbol> symbolsToChange = new ArrayList<OCSymbol>();
        OCSymbol associatedSymbol = this.mySymbol.getAssociatedSymbol(project);
        if (this.mySymbol instanceof OCMemberSymbol && this.myChangeAssociatedSymbol) {
            ((OCMemberSymbol)this.mySymbol).getParent().processMembersInAllCategories(this.mySymbol.getName(), this.mySymbol.getClass(), member -> {
                if (member != associatedSymbol && !member.isSynthetic() && this.needToChangeType((OCSymbol)member, file)) {
                    symbolsToChange.add((OCSymbol)member);
                }
                return true;
            }, false, project);
        } else if ((this.mySymbol instanceof OCFunctionSymbol || this.mySymbol instanceof OCDeclaratorSymbol) && this.myChangeAssociatedSymbol) {
            this.mySymbol.processSameSymbols((Processor<OCSymbol>)((Processor)symbol -> {
                if (this.needToChangeType((OCSymbol)symbol, file)) {
                    symbolsToChange.add((OCSymbol)symbol);
                }
                return true;
            }), project);
        } else {
            symbolsToChange.add(this.mySymbol);
        }
        if (this.myChangeAssociatedSymbol) {
            OCPropertySymbol property;
            if (associatedSymbol != null && this.needToChangeType(associatedSymbol, file)) {
                symbolsToChange.add(associatedSymbol);
            }
            OCResolveContext context = OCResolveContext.forPsi((PsiElement)file);
            if (this.mySymbol instanceof OCPropertySymbol) {
                ((OCPropertySymbol)this.mySymbol).processAccessorMethods((Processor<? super OCMethodSymbol>)((Processor)method -> {
                    if (method.isGetter(context)) {
                        symbolsToChange.add((OCSymbol)method);
                    } else if (method.isSetter(context)) {
                        symbolsToChange.add(method.getSelectors().get(0).getParameter());
                    }
                    return true;
                }), true, project);
                OCInstanceVariableSymbol ivar = ((OCPropertySymbol)this.mySymbol).getAssociatedIvar(project);
                if (ivar != null && this.needToChangeType(ivar, file)) {
                    int code;
                    String message = OCInspectionsBundle.message("intention.dialog.message.change.type.as.well", ivar.getNameWithKindLowercase(context));
                    int n = code = ApplicationManager.getApplication().isUnitTestMode() || ivar.isClang4ImplicitIvar(project) ? 0 : Messages.showYesNoCancelDialog((String)message, (String)OCInspectionsBundle.message("intentions.change.type.capitalized", new Object[0]), (Icon)Messages.getQuestionIcon());
                    if (code == 0) {
                        symbolsToChange.add(ivar);
                    } else if (code == 2) {
                        return;
                    }
                }
            } else if (this.mySymbol instanceof OCInstanceVariableSymbol && (property = ((OCInstanceVariableSymbol)this.mySymbol).getAssociatedProperty(project)) != null && this.needToChangeType(property, file)) {
                if (((OCInstanceVariableSymbol)this.mySymbol).getGeneratedFromProperty() != null) {
                    symbolsToChange.add(property);
                    this.myChangeProperty = true;
                } else {
                    int code;
                    String message = OCInspectionsBundle.message("intention.dialog.message.change.type.as.well", property.getNameWithKindLowercase(context));
                    int n = code = ApplicationManager.getApplication().isUnitTestMode() ? 0 : Messages.showYesNoCancelDialog((String)message, (String)OCInspectionsBundle.message("intentions.change.type.capitalized", new Object[0]), (Icon)Messages.getQuestionIcon());
                    if (code == 0) {
                        symbolsToChange.add(property);
                        this.myChangeProperty = true;
                    } else if (code == 2) {
                        return;
                    }
                }
            }
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            OCSymbol symbol2;
            HashMap<OCSymbol, SmartPsiElementPointer> elementPtrs = new HashMap<OCSymbol, SmartPsiElementPointer>();
            for (OCSymbol symbol2 : symbolsToChange) {
                PsiElement element = symbol2 != null ? symbol2.locateDefinition(project) : null;
                if (element == null) continue;
                elementPtrs.put(symbol2, SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer(element));
            }
            Iterator<Object> iterator2 = elementPtrs.keySet().iterator();
            while (iterator2.hasNext() && this.doChangeType(((SmartPsiElementPointer)elementPtrs.get(symbol2 = (OCSymbol)iterator2.next())).getElement(), symbol2)) {
            }
        });
    }

    private boolean needToChangeType(OCSymbol symbol, @NotNull PsiFile file) {
        OCType resolvedType;
        OCType type;
        OCType oCType = type = symbol instanceof OCMethodSymbol ? ((OCMethodSymbol)symbol).getReturnType(file.getProject()) : symbol.getType();
        if (this.myReturnTypeMode) {
            if (!(type instanceof OCFunctionType)) {
                return true;
            }
            type = ((OCFunctionType)type).getReturnType();
        }
        if ((resolvedType = type.resolve((PsiElement)file)) instanceof OCCppReferenceType) {
            OCCppReferenceType refType = (OCCppReferenceType)resolvedType;
            resolvedType = refType.getRefType();
        }
        if (resolvedType instanceof OCTypeParameterType) {
            return false;
        }
        OCResolveContext resolveContext = OCResolveContext.forPsi((PsiElement)file);
        return !new OCTypeEqualityAfterResolvingVisitor(this.mySubstitutionType, false, false, false, false, true, resolveContext).equal(type);
    }

    private static OCTypeElement getTypeElement(@NotNull OCDeclaration declaration) {
        OCTypeElement trailingReturnType;
        if (declaration instanceof OCFunctionDeclaration && (trailingReturnType = ((OCFunctionDeclaration)declaration).getTrailingReturnTypeElement()) != null) {
            return trailingReturnType;
        }
        return declaration.getTypeElement();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean doChangeType(@NotNull PsiElement element, @NotNull OCSymbol symbol) {
        OCTypeElement typeElement;
        if (!FileModificationService.getInstance().prepareFileForWrite(element.getContainingFile())) {
            return false;
        }
        OCDeclarator myDeclarator = null;
        OCType type = this.mySubstitutionType;
        if (element instanceof OCDeclarator) {
            myDeclarator = (OCDeclarator)element;
            typeElement = ((OCDeclaration)element.getParent()).getTypeElement();
        } else if (element instanceof OCMethodSelectorPart) {
            typeElement = ((OCMethodSelectorPart)element).getTypeElement();
        } else if (element instanceof OCMethod) {
            typeElement = ((OCMethod)element).getReturnTypeElement();
        } else if (element instanceof OCBlockExpression) {
            typeElement = ((OCBlockExpression)element).getReturnTypeElement();
        } else if (element instanceof OCLambdaExpression) {
            typeElement = ((OCLambdaExpression)element).getReturnTypeElement();
        } else {
            if (!(element instanceof OCReferenceElement) || !(element.getParent() instanceof OCSynthesizeProperty) || !this.myChangeProperty) return true;
            if ((symbol = ((OCInstanceVariableSymbol)symbol).getAssociatedProperty(element.getProject())) == null) {
                return true;
            }
            if (!((element = symbol.locateDefinition(element.getProject())) instanceof OCDeclarator)) return true;
            myDeclarator = (OCDeclarator)element;
            typeElement = ((OCDeclaration)element.getParent()).getTypeElement();
        }
        if (typeElement == null) {
            void var7_10;
            if (!(element instanceof OCBlockExpression)) return true;
            OCTypeElement newTypeElement = OCElementFactory.typeElementFromText(type.getBestNameInContext(element), element);
            OCParameterList oCParameterList = ((OCBlockExpression)element).getParameterList();
            if (oCParameterList == null) {
                OCBlockStatement oCBlockStatement = ((OCBlockExpression)element).getBody();
            }
            element.addBefore((PsiElement)newTypeElement, (PsiElement)var7_10);
            return true;
        }
        if (myDeclarator != null) {
            OCDeclaration declaration = OCNormalizeUtil.normalizeDeclarator(myDeclarator);
            if (declaration == null) {
                return true;
            }
            element = declaration.getDeclarators().get(0);
            PsiManager psiManager = element.getManager();
            PsiElement asterisk = OCElementFactory.createLeaf(psiManager, (OCElementType)OCTokenTypes.MUL);
            PsiElement roof = OCElementFactory.createLeaf(psiManager, (OCElementType)OCTokenTypes.XOR);
            PsiElement ampersand = OCElementFactory.createLeaf(psiManager, (OCElementType)OCTokenTypes.AND);
            PsiElement doubleAmpersand = OCElementFactory.createLeaf(psiManager, (OCElementType)OCTokenTypes.ANDAND);
            PsiElement constKeyword = OCElementFactory.createLeaf(psiManager, OCTokenTypes.CONST_KEYWORD);
            PsiElement volatileKeyword = OCElementFactory.createLeaf(psiManager, OCTokenTypes.VOLATILE_KEYWORD);
            ArrayList<PsiElement> declaratorModifiers = new ArrayList<PsiElement>();
            boolean isBlockType = type instanceof OCBlockPointerType;
            if (!this.myReturnTypeMode) {
                while ((type instanceof OCPointerType && !type.isPointerToID() && !((OCPointerType)type).isArrayLikeParameter() || type instanceof OCCppReferenceType) && type.getAliasName() == null) {
                    if (type.isConst()) {
                        declaratorModifiers.add(0, constKeyword);
                    }
                    if (type.isVolatile()) {
                        declaratorModifiers.add(0, volatileKeyword);
                    }
                    if (type instanceof OCCppReferenceType) {
                        OCCppReferenceType referenceType = (OCCppReferenceType)type;
                        declaratorModifiers.add(0, referenceType.isRvalueRef() ? doubleAmpersand : ampersand);
                        type = referenceType.getRefType();
                        continue;
                    }
                    declaratorModifiers.add(0, isBlockType && declaratorModifiers.isEmpty() ? roof : asterisk);
                    type = ((OCPointerType)type).getRefType();
                }
                for (OCDeclarator declarator : declaration.getDeclarators()) {
                    boolean isPointerToFunction = declarator.isPointerToFunction();
                    this.removeAllModifiers(declarator);
                    if (declaration instanceof OCFunctionDeclaration && !isPointerToFunction) continue;
                    for (PsiElement token : declaratorModifiers) {
                        OCChangeTypeIntentionAction.addModifier(declarator, token.copy());
                    }
                }
                if (type instanceof OCFunctionType) {
                    if (((OCDeclarator)element).getParameterList() != null) {
                        OCChangeTypeIntentionAction.changeFunctionType((OCDeclarator)element, (OCFunctionType)type);
                        return true;
                    } else {
                        OCDeclarationStatement newDeclaration = OCElementFactory.declarationStatement(myDeclarator.getName(), this.mySubstitutionType, myDeclarator.getInitializer(), declaration);
                        OCChangeUtil.replaceHandlingMacros(declaration, newDeclaration.getDeclaration());
                    }
                    return true;
                }
            } else if (declaration instanceof OCFunctionDeclaration) {
                for (OCDeclarator declarator : declaration.getDeclarators()) {
                    this.removeAllModifiers(declarator);
                }
            }
            typeElement = OCChangeTypeIntentionAction.getTypeElement(declaration);
            this.removeAllModifiers(typeElement);
            if (typeElement == null || typeElement.getType().equals(type, OCResolveContext.forPsi(typeElement))) {
                return true;
            }
        }
        if (element instanceof OCBlockExpression && type.isVoid()) {
            OCChangeUtil.delete(typeElement);
            return true;
        } else {
            PsiElement maybeTrailing;
            OCFunctionDefinition oCFunctionDefinition;
            OCTypeElement trailingReturnTypeElem;
            PsiElement symbolToUpdate;
            OCParameterDeclaration oldParamDecl;
            if (type instanceof OCPointerType && ((OCPointerType)type).isArrayLikeParameter() && element.getParent() instanceof OCParameterDeclaration) {
                OCArrayType oCArrayType = OCArrayType.fromPointer((OCPointerType)type);
                oldParamDecl = (OCParameterDeclaration)element.getParent();
                String paramName = ((PsiNamedElement)element).getName();
                OCExpression defaultValue = myDeclarator != null ? myDeclarator.getInitializer() : null;
                OCParameterDeclaration paramDecl = OCElementFactory.paramDeclarationByNameAndType(paramName, oCArrayType, defaultValue, element);
                symbolToUpdate = OCChangeUtil.replaceHandlingMacros(oldParamDecl, paramDecl);
            } else {
                OCTypeElement oCTypeElement = OCElementFactory.typeElementFromText(type.getBestNameInContext(typeElement), element);
                OCElementUtil.replaceDeclarationQualifiers(oCTypeElement, typeElement);
                symbolToUpdate = OCChangeUtil.replaceHandlingMacros(typeElement, oCTypeElement);
            }
            if (OCElementUtil.isElementEmpty(symbolToUpdate) && (oldParamDecl = myDeclarator.getParent()) instanceof OCFunctionDefinition && (trailingReturnTypeElem = (oCFunctionDefinition = (OCFunctionDefinition)((Object)oldParamDecl)).getTrailingReturnTypeElement()) != null && (maybeTrailing = PsiTreeUtil.findSiblingBackward((PsiElement)trailingReturnTypeElem, (IElementType)OCLexerTokenTypes.DEREF, null)) != null) {
                OCChangeUtil.delete(maybeTrailing);
            }
            OCImportSymbolFix.fixAllSymbolsRecursively(symbolToUpdate);
        }
        return true;
    }

    private static void changeFunctionType(@NotNull OCDeclarator declarator, @NotNull OCFunctionType newFunctionType) {
        OCFunctionDeclaration functionDef;
        OCParameterList parameterList = declarator.getParameterList();
        OCResolveContext context = OCResolveContext.forPsi(declarator);
        if (declarator.getParent() instanceof OCFunctionDeclaration && !(functionDef = (OCFunctionDeclaration)declarator.getParent()).getReturnType().equalsAfterResolving(newFunctionType.getReturnType(), context)) {
            OCTypeElement newTypeElement = OCElementFactory.typeElementFromText(newFunctionType.getReturnType().getBestNameInContext(context), declarator);
            OCChangeUtil.replaceHandlingMacros(functionDef.getTypeElement(), newTypeElement);
        }
        if (parameterList == null) {
            return;
        }
        Iterator<OCType> newTypesItr = newFunctionType.getParameterTypes(true).iterator();
        HashSet<String> createdNames = new HashSet<String>();
        for (OCParameterDeclaration param : parameterList.getParameterDeclarations()) {
            if (newTypesItr.hasNext()) {
                OCType newType = newTypesItr.next();
                if (newType.isVoid()) {
                    OCChangeUtil.delete(param);
                    break;
                }
                OCDeclarator paramDeclarator = param.getDeclarator();
                if (paramDeclarator != null) {
                    if (paramDeclarator.getType().equalsAfterResolving(newType, context)) continue;
                    String paramName = paramDeclarator.getNameIdentifier() != null ? paramDeclarator.getName() : "";
                    OCChangeUtil.replaceHandlingMacros(param, OCElementFactory.paramDeclarationByNameAndType(paramName, newType, null, declarator));
                    continue;
                }
                String newName = OCNameSuggester.suggestForType(newType, (PsiElement)declarator, createdNames, context).iterator().next();
                createdNames.add(newName);
                param.replace(OCElementFactory.paramDeclarationByNameAndType(newName, newType, null, declarator));
                continue;
            }
            OCChangeUtil.delete(param);
        }
        while (newTypesItr.hasNext()) {
            OCType type = newTypesItr.next();
            String newName = OCNameSuggester.suggestForType(type, (PsiElement)declarator, createdNames, context).iterator().next();
            createdNames.add(newName);
            OCChangeUtil.add(parameterList, OCElementFactory.paramDeclarationByNameAndType(newName, type, null, declarator));
        }
        if (newFunctionType.isConst()) {
            declarator.addAfter(OCElementFactory.create(OCTokenTypes.CONST_KEYWORD, declarator), parameterList);
        }
        if (newFunctionType.isVolatile()) {
            declarator.addAfter(OCElementFactory.create(OCTokenTypes.VOLATILE_KEYWORD, declarator), parameterList);
        }
    }

    private void removeAllModifiers(PsiElement element) {
        if (element == null) {
            return;
        }
        ASTNode parent = element.getNode();
        ASTNode child = parent.getFirstChildNode();
        ArrayList<PsiElement> elemsToRemove = new ArrayList<PsiElement>();
        ArrayList<Pair> rangesToRemove = new ArrayList<Pair>();
        PsiElement rangeStart = null;
        while (child != null) {
            IElementType tt = child.getElementType();
            ASTNode nextChild = child.getTreeNext();
            if (this.myReturnTypeMode && tt == OCElementTypes.PARAMETER_LIST) break;
            if (OCTokenTypes.DECLARATOR_MODIFIERS.contains(tt)) {
                elemsToRemove.add(child.getPsi());
            } else if (tt == OCTokenTypes.LBRACKET) {
                rangeStart = child.getPsi();
            } else if (tt == OCTokenTypes.RBRACKET) {
                if (rangeStart != null) {
                    rangesToRemove.add(Pair.create((Object)rangeStart, (Object)child.getPsi()));
                }
                rangeStart = null;
            }
            child = nextChild;
        }
        for (PsiElement psiElement : elemsToRemove) {
            psiElement.delete();
        }
        for (Pair pair : rangesToRemove) {
            element.deleteChildRange((PsiElement)pair.getFirst(), (PsiElement)pair.getSecond());
        }
    }

    private static void addModifier(PsiElement element, PsiElement token) {
        if (element == null) {
            return;
        }
        ASTNode parent = element.getNode();
        for (ASTNode child = parent.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (child.getElementType() != OCTokenTypes.IDENTIFIER) continue;
            OCChangeUtil.addChild(parent, token.getNode(), child);
            return;
        }
        OCChangeUtil.addChild(parent, token.getNode(), parent.getFirstChildNode());
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }
}

