/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import org.jetbrains.annotations.NotNull;

public class OCChangeMethodStaticnessIntentionAction
extends OCSymbolQuickFix<OCMethodSymbol> {
    private boolean myMakeStatic;

    public OCChangeMethodStaticnessIntentionAction(@NotNull OCMethodSymbol methodSymbol, boolean makeStatic, @NotNull Project project) {
        super(project, methodSymbol);
        this.myMakeStatic = makeStatic;
    }

    @Override
    protected String getTextInternal() {
        return OCInspectionsBundle.message("intention.name.make.class.method.instance.method", ((OCMethodSymbol)this.mySymbol).getPresentableName(), this.myMakeStatic ? 0 : 1);
    }

    @NotNull
    public String getFamilyName() {
        return OCInspectionsBundle.message("intentions.change.method.staticness.action", new Object[0]);
    }

    @Override
    protected void invoke(@NotNull Project project, Editor editor) {
        this.processMethod((OCMethodSymbol)this.mySymbol, project);
        this.processMethod(((OCMethodSymbol)this.mySymbol).getAssociatedSymbol(project), project);
    }

    private void processMethod(OCMethodSymbol symbol, @NotNull Project project) {
        if (symbol == null) {
            return;
        }
        PsiElement element = symbol.locateDefinition(project);
        if (element instanceof OCMethod && FileModificationService.getInstance().prepareFileForWrite(element.getContainingFile())) {
            OCMethod method = (OCMethod)element;
            method.setStatic(this.myMakeStatic);
        }
    }
}

