/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureActionHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureHandler;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCChangeMethodSignatureIntentionAction
extends OCSymbolQuickFix<OCMethodSymbol> {
    @IntentionName
    private final String myText;
    private List<OCType> myNewParamTypes;
    private List<String> myNewSelectors;
    private List<OCExpression> myNewExpressions;

    public OCChangeMethodSignatureIntentionAction(@NotNull OCMethodSymbol methodSymbol, List<OCType> newParamTypes, List<String> newSelectors, List<OCExpression> newExpressions, @NotNull OCCompilationContext context) {
        super(context.getProject(), methodSymbol);
        this.myNewParamTypes = newParamTypes;
        this.myNewSelectors = newSelectors;
        this.myNewExpressions = newExpressions;
        this.myText = OCInspectionsBundle.message("intention.name.add.parameters", ((OCMethodSymbol)this.mySymbol).getNameWithKindLowercase(context));
    }

    @Override
    protected String getTextInternal() {
        return this.myText;
    }

    @NotNull
    public String getFamilyName() {
        return OCInspectionsBundle.message("intentions.change.method.signature.add.parameters", new Object[0]);
    }

    @Override
    protected void invoke(@NotNull Project project, Editor editor) {
        OCChangeSignatureHandler handler = this.prepareHandler(project);
        if (handler != null) {
            handler.invokeSynchronously();
        }
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        String oldSignature = this.getOldSignature(project);
        String newSignature = this.getNewSignature(project);
        return StringUtil.isNotEmpty((String)oldSignature) && StringUtil.isNotEmpty((String)newSignature) ? new IntentionPreviewInfo.CustomDiff(file.getFileType(), oldSignature, newSignature) : IntentionPreviewInfo.EMPTY;
    }

    @Nullable
    private String getOldSignature(@NotNull Project project) {
        PsiElement method = ((OCMethodSymbol)this.mySymbol).locateDefinition(project);
        if (!(method instanceof OCMethod)) {
            return null;
        }
        OCChangeSignatureHandler handler = OCChangeSignatureActionHandler.getHandler((OCMethod)method, method, true);
        return handler.getNewSignature(false);
    }

    @Nullable
    private String getNewSignature(@NotNull Project project) {
        OCChangeSignatureHandler handler = this.prepareHandler(project);
        return handler != null ? handler.getNewSignature(false) : null;
    }

    @Nullable
    private OCChangeSignatureHandler prepareHandler(@NotNull Project project) {
        int i;
        PsiElement method = ((OCMethodSymbol)this.mySymbol).locateDefinition(project);
        if (!(method instanceof OCMethod)) {
            return null;
        }
        OCChangeSignatureHandler handler = OCChangeSignatureActionHandler.getHandler((OCMethod)method, method, true);
        int oldSelectorsCnt = OCNameSuggester.isObjCGetter(((OCMethodSymbol)this.mySymbol).getName()) ? 0 : ((OCMethodSymbol)this.mySymbol).getSelectors().size();
        HashSet<String> prevParamNames = new HashSet<String>();
        for (i = 0; i < oldSelectorsCnt; ++i) {
            OCDeclaratorSymbol parameter = ((OCMethodSymbol)this.mySymbol).getSelectors().get(i).getParameter();
            if (parameter == null) continue;
            prevParamNames.add(parameter.getName());
        }
        for (i = oldSelectorsCnt; i < this.myNewSelectors.size(); ++i) {
            String selector = this.myNewSelectors.get(i);
            OCExpression expression = this.myNewExpressions.get(i);
            String paramName = OCNameSuggester.suggestForParameter(prevParamNames, i == 0, selector, this.myNewParamTypes.get(i), (OCMethodSymbol)this.mySymbol, expression, OCResolveContext.forPsi(method));
            prevParamNames.add(paramName);
            handler.addParameter(selector, paramName, this.myNewParamTypes.get(i), -1, false);
        }
        return handler;
    }
}

