/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.CommonBundle;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.daemon.OCConstantExpressionVisitor;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureActionHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCParameterInfo;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class OCChangeFunctionSignatureIntentionAction
extends OCSymbolQuickFix<OCFunctionSymbol> {
    private final List<OCType> myParameterTypes;
    private final List<OCExpression> myArguments;
    @IntentionName
    private final String myText;

    public OCChangeFunctionSignatureIntentionAction(@NotNull OCFunctionSymbol functionSymbol, @NotNull OCFunctionType newType, @NotNull List<OCExpression> arguments, @NotNull OCResolveContext context, @NotNull PsiElement psiContext) {
        super(context.getProject(), functionSymbol);
        OCParameterList parameterList;
        this.myParameterTypes = new ArrayList<OCType>(newType.getParameterTypes(true));
        this.myArguments = arguments;
        PsiElement declarator = ((OCFunctionSymbol)this.mySymbol).locateDefinition(context.getProject());
        if (declarator instanceof OCDeclarator && (parameterList = ((OCDeclarator)declarator).getParameterList()) != null) {
            List<OCParameterDeclaration> parameterDeclarations = parameterList.getParameterDeclarations();
            for (int i = 0; i < parameterDeclarations.size() && i < this.myParameterTypes.size(); ++i) {
                OCDeclarator paramDecl = parameterDeclarations.get(i).getDeclarator();
                if (paramDecl == null) continue;
                OCType type = paramDecl.getResolvedType();
                if (i <= 0 && type.isVoid()) continue;
                this.myParameterTypes.set(i, type);
            }
        }
        int argsCnt = functionSymbol.getParameterSymbols().size();
        this.myText = this.myParameterTypes.size() == argsCnt + 1 ? OCInspectionsBundle.message("intention.name.add.last.parameter", ((OCType)ContainerUtil.getLastItem(this.myParameterTypes)).getBestNameInContext(psiContext), ((OCFunctionSymbol)this.mySymbol).getNameWithKindLowercase(context)) : (this.myParameterTypes.size() == argsCnt - 1 ? OCInspectionsBundle.message("intention.name.remove.last.parameter", ((OCDeclaratorSymbol)ContainerUtil.getLastItem(functionSymbol.getParameterSymbols())).getType().getBestNameInContext(psiContext), ((OCFunctionSymbol)this.mySymbol).getNameWithKindLowercase(context)) : OCInspectionsBundle.message("intention.name.change.signature", ((OCFunctionSymbol)this.mySymbol).getNameWithKindLowercase(context), new OCFunctionType(newType.getReturnType(), this.myParameterTypes).getName(context)));
    }

    @Override
    protected String getTextInternal() {
        return this.myText;
    }

    @NotNull
    public String getFamilyName() {
        return OCInspectionsBundle.message("intentions.change.function.signature", new Object[0]);
    }

    @Override
    public boolean isAvailable() {
        return super.isAvailable() && this.myText != null && !((OCFunctionSymbol)this.mySymbol).isSynthetic() && ContainerUtil.and(this.myParameterTypes, OCType::isInstanceable) && !((OCFunctionSymbol)this.mySymbol).isCppDestructor();
    }

    @Override
    protected void invoke(@NotNull Project project, Editor editor) {
        PsiElement declarator = ((OCFunctionSymbol)this.mySymbol).locateDefinition(project);
        if (!(declarator instanceof OCDeclarator) || !(declarator.getParent() instanceof OCFunctionDeclaration)) {
            return;
        }
        OCFunctionDeclaration function = (OCFunctionDeclaration)declarator.getParent();
        OCChangeSignatureHandler handler = OCChangeSignatureActionHandler.getHandler(function, function, false, true, true, false);
        OCParameterList parameterList = ((OCDeclarator)declarator).getParameterList();
        if (parameterList == null) {
            return;
        }
        handler.setReturnType(((OCFunctionDeclaration)declarator.getParent()).getReturnType());
        HashSet<String> createdNames = new HashSet<String>();
        ArrayList<Trinity> newArguments = new ArrayList<Trinity>();
        int paramIndex = 0;
        boolean hasInitializers = false;
        for (OCParameterDeclaration param : parameterList.getParameterDeclarations()) {
            OCDeclarator paramDecl = param.getDeclarator();
            String paramName = paramDecl != null ? paramDecl.getName() : null;
            OCExpression initializer = paramDecl != null ? paramDecl.getInitializer() : null;
            handler.removeParameter(0);
            boolean bl = hasInitializers = initializer != null;
            if (paramName != null) {
                createdNames.add(paramName);
            }
            if (paramIndex >= this.myParameterTypes.size()) continue;
            newArguments.add(Trinity.create((Object)(paramName != null ? paramName : ""), (Object)this.myParameterTypes.get(paramIndex++), (Object)initializer));
        }
        OCResolveContext context = OCResolveContext.forPsi(declarator);
        boolean disableInitializers = false;
        while (paramIndex < this.myParameterTypes.size()) {
            Collection<String> suggestedNames;
            OCExpression initializer;
            OCExpression oCExpression = initializer = hasInitializers && paramIndex < this.myArguments.size() ? this.myArguments.get(paramIndex) : null;
            if (initializer != null && !new OCConstantExpressionVisitor().isConstant(initializer)) {
                disableInitializers = true;
            }
            OCType newType = this.myParameterTypes.get(paramIndex++);
            if (hasInitializers && initializer == null) {
                initializer = OCElementFactory.expressionFromText(newType.getDefaultValue(context), declarator);
            }
            @NlsSafe String suggestedName = (suggestedNames = OCNameSuggester.suggestForType(OCSymbolKind.PARAMETER, newType, declarator, "", createdNames, context)).isEmpty() ? "param" : suggestedNames.iterator().next();
            createdNames.add(suggestedName);
            newArguments.add(Trinity.create((Object)suggestedName, (Object)newType, (Object)initializer));
        }
        String message = OCInspectionsBundle.message("intention.dialog.message.existing.default.values.removed", ((OCFunctionSymbol)this.mySymbol).getNameWithKindLowercase(context));
        if (hasInitializers && disableInitializers && !ApplicationManager.getApplication().isUnitTestMode() && Messages.showOkCancelDialog((Project)context.getProject(), (String)message, (String)CommonBundle.getWarningTitle(), (Icon)Messages.getQuestionIcon()) != 0) {
            return;
        }
        int index = 0;
        for (Trinity argument : newArguments) {
            OCParameterInfo parameterInfo = handler.addParameter((String)argument.getFirst(), (OCType)argument.getSecond(), index++);
            if (disableInitializers) continue;
            parameterInfo.setInitializer((OCExpression)argument.getThird());
        }
        handler.invokeSynchronously();
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }
}

