/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.types.ARCAttribute;
import org.jetbrains.annotations.NotNull;

public class OCChangeARCAttributeIntentionAction
extends OCSymbolQuickFix<OCSymbol> {
    private ARCAttribute myAttribute;
    @IntentionName
    private final String myText;

    public OCChangeARCAttributeIntentionAction(@NotNull OCSymbol symbol, ARCAttribute attribute2, @NotNull OCCompilationContext context) {
        super(context.getProject(), symbol);
        this.myAttribute = attribute2;
        this.myText = OCInspectionsBundle.message("intention.name.make", this.mySymbol.getNameWithKindLowercase(context), this.myAttribute.getTokenName());
    }

    @Override
    protected String getTextInternal() {
        return this.myText;
    }

    @NotNull
    public String getFamilyName() {
        return OCInspectionsBundle.message("intentions.change.arc.attribute", new Object[0]);
    }

    @Override
    protected void invoke(@NotNull Project project, Editor editor) {
        PsiElement declarator = this.mySymbol.locateDefinition(project);
        OCDeclaration declaration = (OCDeclaration)PsiTreeUtil.getParentOfType((PsiElement)declarator, OCDeclaration.class);
        if (declaration == null) {
            return;
        }
        OCTypeElement typeElement = declaration.getTypeElement();
        if (typeElement == null) {
            return;
        }
        OCChangeARCAttributeIntentionAction.removeOldAttributes(typeElement);
        OCChangeARCAttributeIntentionAction.removeOldAttributes(declarator);
        OCChangeUtil.changeText(declaration.getProject(), declaration.getContainingFile(), declaration.getTextOffset(), 0, this.myAttribute.getTokenName() + " ", true);
    }

    private static void removeOldAttributes(PsiElement typeElement) {
        for (ASTNode node : typeElement.getNode().getChildren(null)) {
            IElementType elementType = node.getElementType();
            if (elementType != OCTokenTypes.STRONG_KEYWORD && elementType != OCTokenTypes.WEAK_KEYWORD && elementType != OCTokenTypes.UNSAFE_UNRETAINED_KEYWORD && elementType != OCTokenTypes.AUTORELEASING_KEYWORD) continue;
            OCChangeUtil.delete(node.getPsi());
        }
    }
}

