/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCAddTypeModifierIntentionAction
extends OCSymbolQuickFix<OCSymbol> {
    private final OCElementType myModifier;
    private final String mySubject;
    private boolean myProcessSameSymbols = true;

    public OCAddTypeModifierIntentionAction(@NotNull OCSymbol symbol, OCElementType modifier, @NotNull Project project, @Nullable String subject, boolean processSameSymbols) {
        super(project, symbol);
        this.myModifier = modifier;
        this.mySubject = subject;
        this.myProcessSameSymbols = processSameSymbols;
    }

    public OCAddTypeModifierIntentionAction(@NotNull OCSymbol symbol, OCElementType modifier, Project project, boolean processSameSymbols) {
        this(symbol, modifier, project, symbol.getNameWithKindLowercase(OCCompilationContext.create(symbol, project)), processSameSymbols);
    }

    public OCAddTypeModifierIntentionAction(@NotNull OCSymbol symbol, OCElementType modifier, Project project) {
        this(symbol, modifier, project, true);
    }

    @Override
    protected String getTextInternal() {
        return OCInspectionsBundle.message("intention.name.add.type.modifier", this.mySubject, this.myModifier.getName());
    }

    @NotNull
    public String getFamilyName() {
        return OCInspectionsBundle.message("intentions.add.modifier", this.myModifier.getName());
    }

    @Override
    public boolean isAvailable() {
        if (!super.isAvailable()) {
            return false;
        }
        if (this.myModifier == OCTokenTypes.CONST_KEYWORD && (((OCDeclaratorSymbol)this.mySymbol).isConst() || this.mySymbol.getKind() == OCSymbolKind.ENUM_CONST)) {
            return false;
        }
        if (this.myModifier == OCTokenTypes.BLOCK_KEYWORD && (((OCDeclaratorSymbol)this.mySymbol).isBlockModifiable() || this.mySymbol.getKind() != OCSymbolKind.LOCAL_VARIABLE)) {
            return false;
        }
        if (this.myModifier == OCTokenTypes.VIRTUAL_CPP_KEYWORD && ((OCFunctionSymbol)this.mySymbol).isVirtual()) {
            return false;
        }
        return !this.mySymbol.getKind().isFunction() || this.myModifier != OCTokenTypes.STATIC_KEYWORD || !((OCFunctionSymbol)this.mySymbol).isVirtual();
    }

    @Override
    protected void invoke(@NotNull Project project, Editor editor) {
        List<ASTNode> nodesToUpdate = this.getNodesToUpdate(this.myProcessSameSymbols, project);
        OCFile context = this.mySymbol.getContainingOCFile(project);
        if (nodesToUpdate.isEmpty() || context == null) {
            return;
        }
        for (ASTNode node : nodesToUpdate) {
            node.addChild(OCElementFactory.spaceFromText(context).getNode(), node.getFirstChildNode());
            OCChangeUtil.addChild(node, OCElementFactory.typeModifierFromText(this.myModifier.getName(), context), node.getFirstChildNode());
        }
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        List<ASTNode> nodesToUpdate = this.getNodesToUpdate(false, project);
        if (nodesToUpdate.isEmpty()) {
            return IntentionPreviewInfo.EMPTY;
        }
        ASTNode node = nodesToUpdate.get(0);
        String builder2 = this.myModifier.getName() + " " + node.getText();
        return new IntentionPreviewInfo.CustomDiff(file.getFileType(), node.getText(), builder2);
    }

    private List<ASTNode> getNodesToUpdate(boolean processSameSymbols, @NotNull Project project) {
        if (!OCCodeInsightUtil.isValid(this.mySymbol.locateDefinition(project))) {
            return ContainerUtil.emptyList();
        }
        ArrayList<ASTNode> nodesToUpdate = new ArrayList<ASTNode>();
        Processor processor2 = symbol1 -> {
            PsiElement element = symbol1.locateDefinition(project);
            if (element == null || !(element.getParent() instanceof OCDeclaration)) {
                return true;
            }
            OCTypeElement typeElement = ((OCDeclaration)element.getParent()).getTypeElement();
            if (typeElement == null) {
                return true;
            }
            ASTNode typeNode = typeElement.getNode();
            if (typeNode != null && typeNode.getFirstChildNode() != null && typeNode.findChildByType((IElementType)this.myModifier) == null) {
                nodesToUpdate.add(typeNode);
            }
            return true;
        };
        if (processSameSymbols) {
            this.mySymbol.processSameSymbols((Processor<OCSymbol>)processor2, project);
        } else {
            processor2.process((Object)this.mySymbol);
        }
        return nodesToUpdate;
    }
}

