/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.generate.handlers.OCGenerateConstructorHandler;
import com.jetbrains.cidr.lang.psi.OCConstructorFieldInitializer;
import com.jetbrains.cidr.lang.psi.OCConstructorInitializationList;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.refactoring.OCUniqueNameGenerator;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureActionHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureHandler;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCAddSuperConstructorCallsFix
extends OCSymbolQuickFix<OCFunctionSymbol> {
    private final OCStructSymbol myClassMissingBaseCtors;

    public OCAddSuperConstructorCallsFix(@NotNull OCFunctionSymbol constructor, OCStructSymbol classMissingBaseCtors, @NotNull Project project) {
        super(project, constructor);
        this.myClassMissingBaseCtors = classMissingBaseCtors;
    }

    @Override
    protected String getTextInternal() {
        return OCInspectionsBundle.message("intention.name.add.call.to.base.constructor", this.myClassMissingBaseCtors.getName());
    }

    @NotNull
    public String getFamilyName() {
        return OCInspectionsBundle.message("intentions.add.super.constructor.call", new Object[0]);
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    protected void invoke(@NotNull Project project, Editor editor) {
        List<OCFunctionSymbol> chosenCtors;
        OCFunctionDefinition constructor = (OCFunctionDefinition)((OCFunctionSymbol)this.mySymbol).locateFunctionDefinition(project);
        if (constructor == null) {
            return;
        }
        ArrayList<Collection<OCFunctionSymbol>> baseConstructors = new ArrayList<Collection<OCFunctionSymbol>>();
        CommonProcessors.CollectProcessor collector = new CommonProcessors.CollectProcessor();
        this.myClassMissingBaseCtors.processConstructors((Processor<? super OCFunctionSymbol>)collector, OCResolveContext.forPsi(constructor));
        if (!collector.getResults().isEmpty()) {
            baseConstructors.add(collector.getResults());
        }
        if ((chosenCtors = OCGenerateConstructorHandler.chooseBaseConstructors(baseConstructors, project)) == null) {
            return;
        }
        OCChangeSignatureHandler handler = OCChangeSignatureActionHandler.getHandler(constructor, constructor, true);
        HashSet<String> names = new HashSet<String>(ContainerUtil.map(((OCFunctionSymbol)this.mySymbol).getParameterSymbols(), symbol1 -> symbol1.getName()));
        int index = 0;
        OCConstructorInitializationList list = OCElementFactory.constructorInitializationList(constructor);
        for (OCFunctionSymbol baseConstructor : chosenCtors) {
            StringBuilder builder2 = new StringBuilder();
            builder2.append(baseConstructor.getName()).append("(");
            boolean firstParam = true;
            for (OCDeclaratorSymbol param : baseConstructor.getParameterSymbols()) {
                String name = OCUniqueNameGenerator.suggestUniqueName(OCSymbolKind.PARAMETER, param.getName(), null, names, project);
                names.add(name);
                handler.insertParameter(name, param.getType(), index++);
                if (!firstParam) {
                    builder2.append(",");
                }
                firstParam = false;
                builder2.append(name);
            }
            builder2.append(")");
            OCChangeUtil.add(list, OCElementFactory.constructorFieldInitializerFromText(builder2.toString(), constructor));
        }
        OCConstructorInitializationList existingList = constructor.getConstructorInitializationList();
        if (existingList != null) {
            for (OCConstructorFieldInitializer initializer : existingList.getInitializers()) {
                OCChangeUtil.add(list, initializer);
            }
        }
        handler.getGeneratedInfo().runOnSuccess(() -> constructor.setConstructorInitializationList(list));
        handler.setTitle(this.getText());
        handler.invoke();
    }
}

