/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.inspections.OCInspectionUtil;
import com.jetbrains.cidr.lang.psi.OCConstructorFieldInitializer;
import com.jetbrains.cidr.lang.psi.OCConstructorInitializationList;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.quickfixes.OCAddInitializerIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCAddFieldInitializerFix
extends OCPsiElementQuickFix<OCFunctionDefinition> {
    private final OCDeclaratorSymbol myField;

    public OCAddFieldInitializerFix(@NotNull OCFunctionDefinition constructor, OCDeclaratorSymbol field) {
        super(constructor);
        this.myField = field;
    }

    @Override
    protected boolean isAvailable(@NotNull OCFunctionDefinition constructor) {
        return OCSearchScope.isInProjectSources(this.myField, constructor.getProject());
    }

    @NotNull
    public String getFamilyName() {
        return OCInspectionsBundle.message("intentions.add.constructor.initializer.for.field", new Object[0]);
    }

    @Override
    protected String getTextInternal() {
        return OCInspectionsBundle.message("intention.name.add.constructor.initializer", this.myField.getNameWithKindLowercase(OCCompilationContext.create(this.myField, this.getProject())));
    }

    @Override
    protected void invoke(PsiFile file, @NotNull OCFunctionDefinition constructor) {
        OCResolveContext context = OCResolveContext.forPsi(constructor);
        OCType type = this.myField.getResolvedType(context);
        OCConstructorFieldInitializer initializer = OCAddFieldInitializerFix.addFieldInitializer(constructor, this.myField, type.getDefaultValue(context));
        OCAddInitializerIntentionAction.invokeSmartCompletion(initializer.getArguments().get(0), type);
    }

    public static OCConstructorFieldInitializer addFieldInitializer(OCFunctionDefinition constructor, OCDeclaratorSymbol field, String initializerText) {
        String text = field.getName() + "(" + initializerText + ")";
        OCConstructorFieldInitializer initializer = OCElementFactory.constructorFieldInitializerFromText(text, constructor);
        OCConstructorInitializationList existingList = constructor.getConstructorInitializationList();
        if (existingList != null) {
            initializer = OCChangeUtil.add(existingList, initializer);
        } else {
            OCConstructorInitializationList list = OCElementFactory.constructorInitializationList(constructor);
            OCChangeUtil.add(list, initializer);
            list = constructor.setConstructorInitializationList(list);
            initializer = list.getInitializers().get(0);
        }
        return initializer;
    }

    @Override
    protected boolean shouldCommitAllDocuments() {
        return false;
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        PsiElement copyPsiElement = OCInspectionUtil.findSameElementInCopy((SmartPsiElementPointer)this.myElementPtr, (PsiFile)target);
        return copyPsiElement instanceof OCFunctionDefinition ? new OCAddFieldInitializerFix((OCFunctionDefinition)copyPsiElement, this.myField) : null;
    }
}

