/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.jetbrains.cidr.lang.inspections.OCInspectionUtil;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCAddElementIntentionAction
extends OCPsiElementQuickFix<PsiElement> {
    @IntentionName
    private final String myCaption;
    private final SmartPsiElementPointer<?> myNewElementPtr;
    @IntentionFamilyName
    private final String myFamilyName;

    public OCAddElementIntentionAction(@IntentionFamilyName String caption, @NotNull PsiElement parent, PsiElement newElement) {
        super(parent);
        this.myNewElementPtr = OCElementUtil.createPsiElementPointer(newElement);
        this.myCaption = caption;
        this.myFamilyName = caption;
    }

    @Override
    protected String getTextInternal() {
        return this.myCaption;
    }

    @NotNull
    public String getFamilyName() {
        return this.myFamilyName;
    }

    @Override
    protected void invoke(PsiFile file, @NotNull PsiElement parent) {
        Object elementByPointer = OCElementUtil.getPsiElementByPointer(this.myNewElementPtr);
        if (elementByPointer != null) {
            OCChangeUtil.addBefore(parent, elementByPointer, null);
        }
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        PsiElement elementCopy = OCInspectionUtil.findSameElementInCopy((SmartPsiElementPointer)this.myElementPtr, (PsiFile)target);
        PsiElement newElement = this.myNewElementPtr.getElement();
        if (elementCopy == null || newElement == null || !newElement.isValid()) {
            return null;
        }
        return new OCAddElementIntentionAction(this.myCaption, elementCopy, newElement);
    }

    @Override
    protected boolean shouldCommitAllDocuments() {
        return false;
    }
}

