/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl.symbols;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.Processor;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.jetbrains.cidr.lang.symbols.OCDelegatingSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceLikeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCLazyNamedSymbolCollection;
import com.jetbrains.cidr.lang.symbols.symtable.OCLazyNamedSymbolCollectionImpl;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCFileSymbolsContainerBase
implements Processor<OCSymbol>,
OCNamespaceLikeSymbol {
    @NotNull
    private final PsiFile myFile;
    protected MostlySingularMultiMap<String, OCSymbol> myNameToSymbol = new MostlySingularMultiMap();
    protected Collection<OCUsingSymbol> myUsingSymbols = new ArrayList<OCUsingSymbol>();
    protected Collection<OCNamespaceSymbol> myInlineNamespaces = new ArrayList<OCNamespaceSymbol>();
    protected OCLazyNamedSymbolCollection myLazyNamedSymbols = new OCLazyNamedSymbolCollectionImpl();

    OCFileSymbolsContainerBase(@NotNull PsiFile file) {
        this.myFile = file;
    }

    @Override
    @NotNull
    public PsiFile getContainingPsiFile(@NotNull Project project) {
        return this.myFile;
    }

    @Override
    public boolean processMembers(@Nullable String name, @NotNull Processor<? super OCSymbol> processor2) {
        boolean result;
        Processor<OCSymbol> delegateProcessor = OCDelegatingSymbol.getDelegateProcessor(processor2);
        boolean bl = result = name != null ? this.myNameToSymbol.processForKey((Object)name, delegateProcessor) : this.myNameToSymbol.processAllValues(delegateProcessor);
        if (!result) {
            return false;
        }
        return this.myLazyNamedSymbols.process(delegateProcessor, name);
    }

    @Override
    public Collection<OCUsingSymbol> getNamespaceUsings() {
        return this.myUsingSymbols;
    }

    @Override
    @Nullable
    public Collection<OCNamespaceSymbol> getInlineNamespaces() {
        return this.myInlineNamespaces;
    }
}

