/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.impl.OCElementBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.symbols.DeclarationContext;
import com.jetbrains.cidr.lang.symbols.OCBuilderDriver;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolReferenceResolver;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeBuilder;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Arrays;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class OCTypeElementImpl
extends OCElementBase
implements OCTypeElement {
    public OCTypeElementImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitTypeElement(this);
    }

    @Override
    @NotNull
    public OCType getType() {
        return this.getRawType();
    }

    @Override
    @NotNull
    public OCType getRawType() {
        return this.getRawType(false);
    }

    @Override
    @ApiStatus.Experimental
    @NotNull
    public OCType getRawType(boolean assumeNonNull) {
        OCFile file = this.getContainingOCFile();
        ASTNode node = this.getNode();
        ASTNode childNode = node.getFirstChildNode();
        IElementType tt = OCElementUtil.getElementType(childNode);
        if (tt == OCTokenTypes.TYPEOF_KEYWORD || tt == OCTokenTypes.DECLTYPE_CPP_KEYWORD) {
            PsiElement[] children = this.getChildren();
            if (children.length == 1 && children[0] instanceof OCExpression) {
                return ((OCExpression)children[0]).getResolvedType();
            }
            if (Arrays.stream(this.getNode().getChildren(null)).anyMatch(n -> OCTokenTypes.AUTO_KEYWORDS.contains(n.getElementType()))) {
                return new OCAutoType();
            }
            return OCUnknownType.INSTANCE;
        }
        OCBuilderDriver<ASTNode> builderDriver = OCBuilderDriver.createForASTNode(node, file);
        DeclarationContext context = new DeclarationContext(null, null, null, null, this, assumeNonNull);
        OCTypeBuilder typeBuilder = builderDriver.createTypeBuilder(context);
        OCSymbolWithQualifiedName parent = OCSymbolReferenceResolver.getGlobalContextFromLocal(this);
        context = new DeclarationContext(null, null, parent, null, this, assumeNonNull);
        typeBuilder.setLocalContext(context);
        return builderDriver.processTypeElement(node, typeBuilder, (Processor<OCSymbol>)CommonProcessors.alwaysTrue(), context);
    }

    @Override
    public int getArrayLengths() {
        return this.getNode().getChildren(TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.LBRACKET})).length;
    }

    @Override
    public boolean isEmptyType() {
        PsiElement child = this.getFirstChild();
        return child == null || OCElementUtil.getElementType(child) == OCElementTypes.EMPTY_NAME;
    }
}

