/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCPropertyAttributesList;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCSynthesizePropertiesList;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.psi.impl.OCElementBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCSynthesizeSymbol;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class OCSynthesizePropertyImpl
extends OCElementBase
implements OCSynthesizeProperty,
PsiNamedElement {
    public OCSynthesizePropertyImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitSynthesizeProperty(this);
    }

    @Override
    public OCReferenceElement getPropertyRef() {
        return (OCReferenceElement)this.findChildByType((IElementType)OCElementTypes.REFERENCE_ELEMENT);
    }

    @Override
    public OCReferenceElement getInstanceVariableRef() {
        List children = this.findChildrenByType((IElementType)OCElementTypes.REFERENCE_ELEMENT);
        return children.size() == 2 ? (OCReferenceElement)children.get(1) : null;
    }

    @Override
    public boolean isSynthesize() {
        OCSynthesizePropertiesList parent = (OCSynthesizePropertiesList)this.getContext();
        return parent != null && parent.isSynthesize();
    }

    @Override
    public OCPropertyAttributesList getPropertyAttributesList() {
        return (OCPropertyAttributesList)this.findChildByType((IElementType)OCElementTypes.PROPERTY_ATTRIBUTES_LIST);
    }

    @Override
    public OCSynthesizeSymbol getSymbol() {
        OCClassDeclaration classDecl = (OCClassDeclaration)PsiTreeUtil.getContextOfType((PsiElement)this, (Class[])new Class[]{OCClassDeclaration.class});
        OCReferenceElement propertyRef = this.getPropertyRef();
        if (classDecl == null || propertyRef == null) {
            return null;
        }
        OCClassSymbol clazz = classDecl.getSymbol();
        if (clazz != null) {
            CommonProcessors.FindFirstProcessor processor2 = new CommonProcessors.FindFirstProcessor();
            clazz.processMembers(propertyRef.getCanonicalText(), OCSynthesizeSymbol.class, processor2);
            return (OCSynthesizeSymbol)processor2.getFoundValue();
        }
        return null;
    }

    @NotNull
    public String getName() {
        return "@synthesize";
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        throw new UnsupportedOperationException("setName is not implemented");
    }

    @Override
    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            public String getPresentableText() {
                return OCSynthesizePropertyImpl.this.getName();
            }

            public String getLocationString() {
                OCClassDeclaration clazz = (OCClassDeclaration)PsiTreeUtil.getContextOfType((PsiElement)OCSynthesizePropertyImpl.this, (Class[])new Class[]{OCClassDeclaration.class});
                assert (clazz != null);
                ItemPresentation classPresentation = clazz.getPresentation();
                return classPresentation != null ? classPresentation.getPresentableText() : "";
            }

            public Icon getIcon(boolean open) {
                return null;
            }
        };
    }
}

