/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.MultiRangeReference;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ReferenceRange;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiPolyVariantCachingReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentSelector;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCMessageArgument;
import com.jetbrains.cidr.lang.psi.OCPolyVariantReference;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.impl.OCExpressionWithReferenceBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCObjectTypeContext;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeGuesser;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityAfterResolvingVisitor;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSendMessageExpressionImpl
extends OCExpressionWithReferenceBase<OCPolyVariantReference<OCMethodSymbol>>
implements OCSendMessageExpression {
    public OCSendMessageExpressionImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public OCExpression getReceiverExpression() {
        return (OCExpression)this.findChildByType(OCElementTypes.EXPRESSIONS);
    }

    @Override
    @NotNull
    public List<OCMessageArgument> getArguments() {
        return this.findChildrenByType((IElementType)OCElementTypes.MESSAGE_ARGUMENT);
    }

    @Override
    @NotNull
    public List<OCArgumentSelector> getArgumentSelectors() {
        ArrayList<OCArgumentSelector> result = new ArrayList<OCArgumentSelector>();
        for (OCMessageArgument argument : this.getArguments()) {
            result.add(argument.getArgumentSelector());
        }
        return result;
    }

    @Override
    @NotNull
    public List<OCExpression> getArgumentExpressions() {
        ArrayList<OCExpression> expressions = new ArrayList<OCExpression>();
        for (OCMessageArgument argument : this.getArguments()) {
            OCExpression expression = argument.getArgumentExpression();
            if (expression == null) continue;
            expressions.add(expression);
        }
        return expressions;
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitSendMessageExpression(this);
    }

    @Override
    @NotNull
    public String getMessageSelector() {
        StringBuilder builder2 = new StringBuilder();
        for (OCMessageArgument argument : this.getArguments()) {
            builder2.append(argument.getArgumentSelector().getSelectorName());
        }
        return builder2.toString();
    }

    @Override
    public boolean isVarargCall() {
        boolean isVararg = false;
        for (OCMessageArgument argument : this.getArguments()) {
            isVararg = argument.getArgumentSelector().isEmpty();
        }
        return isVararg;
    }

    @Override
    @NotNull
    public OCType getType(@NotNull OCResolveContext context) {
        OCType guessedType;
        OCType type = null;
        OCSendMessageExpression.ProbableResponders probableResponders = this.getProbableResponders();
        List<OCMethodSymbol> responders = probableResponders.getFilteredByStaticnessResponders();
        for (OCMethodSymbol method : responders) {
            OCType returnType = method.getEffectiveType(probableResponders.getReceiverType(), this).resolve(context);
            if (type == null || type.isUnknown() || type.isUnresolved(context)) {
                type = returnType;
                continue;
            }
            if (new OCTypeEqualityAfterResolvingVisitor(returnType, true, true, false, true, context).equal(type)) continue;
            type = OCUnknownType.INSTANCE;
            break;
        }
        if (type == null) {
            type = OCUnknownType.INSTANCE;
        }
        if (type.isUnknown() && this.getParent() instanceof OCSendMessageExpression) {
            type = OCIdType.pointerToID();
        }
        return (guessedType = this.getGuessedType()) != null ? type.cloneWithGuessedType(guessedType) : type;
    }

    @Nullable
    private OCType getGuessedType() {
        OCExpression receiver = this.getReceiverExpression();
        SelectorReference methodRef = (SelectorReference)this.getReference();
        List<OCMethodSymbol> symbols = methodRef.resolveToSymbols();
        if (symbols.size() != 1) {
            return null;
        }
        OCMethodSymbol method = symbols.get(0);
        if (receiver != null && method != null) {
            OCObjectTypeContext receiverContext = this.getReceiverContext();
            if (receiverContext == null) {
                return this.getResolvedType();
            }
            return OCTypeGuesser.getMethodGuessedReturnType(method, receiverContext, this, this);
        }
        return null;
    }

    @Override
    @NotNull
    public OCSendMessageExpression.ProbableResponders getProbableResponders() {
        OCObjectTypeContext receiverContext = this.getReceiverContext();
        return receiverContext != null ? receiverContext.getProbableResponders(this.getMessageSelector(), this.getProject()) : new OCSendMessageExpression.ProbableResponders(Collections.emptyList(), Collections.emptyList(), null, null);
    }

    @Override
    @NotNull
    public String getExpectedMethodSignature(OCResolveContext resolveContext) {
        OCType returnExpectedType = OCExpectedTypeUtil.getExpectedType(this, true, resolveContext);
        if (returnExpectedType == OCUnknownType.INSTANCE) {
            returnExpectedType = OCVoidType.instance();
        }
        if (this.getMessageSelector().startsWith("init")) {
            returnExpectedType = OCIdType.pointerToID();
        }
        StringBuilder result = new StringBuilder();
        OCSendMessageExpression.ProbableResponders probableResponders = this.getProbableResponders();
        result.append(probableResponders.isStaticContext() ? (char)'+' : '-');
        result.append('(');
        result.append(returnExpectedType.getName(this)).append(')');
        HashSet<String> createdNames = new HashSet<String>();
        boolean isFirstSelector = true;
        OCResolveContext context = OCResolveContext.forPsi(this);
        for (OCMessageArgument argument : this.getArguments()) {
            String selectorName = argument.getArgumentSelector().getSelectorName();
            result.append(selectorName);
            OCExpression expression = argument.getArgumentExpression();
            if (expression == null) break;
            OCType paramType = OCExpectedTypeUtil.getExpressionType(expression, true);
            String suggestedName = OCNameSuggester.suggestForParameter(createdNames, isFirstSelector, selectorName, paramType, probableResponders.getKnownResponder(), expression, context);
            createdNames.add(suggestedName);
            result.append('(').append(paramType.getName(this)).append(')');
            result.append(suggestedName).append(' ');
            isFirstSelector = false;
        }
        return result.toString();
    }

    @Override
    @Nullable
    public OCObjectTypeContext getReceiverContext() {
        OCExpression receiver = this.getReceiverExpression();
        return receiver != null ? receiver.getTypeContext() : null;
    }

    @Override
    @Nullable
    protected SelectorReference createReference() {
        return new SelectorReference();
    }

    private class SelectorReference
    extends PsiPolyVariantCachingReference
    implements MultiRangeReference,
    OCPolyVariantReference<OCMethodSymbol> {
        SelectorReference() {
        }

        @Override
        @NotNull
        public List<OCMethodSymbol> resolveToSymbols() {
            OCSendMessageExpression.ProbableResponders responders = OCSendMessageExpressionImpl.this.getProbableResponders();
            if (responders.getKnownResponder() != null) {
                return Collections.singletonList(responders.getKnownResponder());
            }
            if (!responders.getFilteredByStaticnessResponders().isEmpty()) {
                return responders.getFilteredByStaticnessResponders();
            }
            return responders.getAllResponders();
        }

        public boolean isReferenceTo(@NotNull PsiElement element) {
            if (!(element instanceof OCSymbolDeclarator)) {
                return false;
            }
            Object symbol = ((OCSymbolDeclarator)element).getSymbol();
            List<OCMethodSymbol> symbols = this.resolveToSymbols();
            if (symbol == null && symbols.isEmpty()) {
                return true;
            }
            Project project = element.getProject();
            if (symbol instanceof OCMethodSymbol) {
                OCMethodSymbol associatedSymbol = ((OCMethodSymbol)symbol).getAssociatedSymbol(project);
                return symbols.contains(symbol) || symbols.contains(associatedSymbol);
            }
            for (OCMethodSymbol methodSymbol : symbols) {
                if (!methodSymbol.isSameSymbol((OCSymbol)symbol, project)) continue;
                return true;
            }
            if (symbol != null) {
                Set<OCSymbol> sameSymbols = this.collectSameSymbols((OCSymbol)symbol, project);
                for (OCMethodSymbol methodSymbol : symbols) {
                    OCMethodSymbol associatedSymbol = methodSymbol.getAssociatedSymbol(project);
                    if (this.checkSameSymbolsContainOriginalSymbol(sameSymbols, methodSymbol)) {
                        return true;
                    }
                    if (!this.checkSameSymbolsContainOriginalSymbol(sameSymbols, associatedSymbol)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean checkSameSymbolsContainOriginalSymbol(@NotNull Set<OCSymbol> set, @Nullable OCMethodSymbol symbol) {
            if (symbol == null) {
                return false;
            }
            OCSymbol originalSymbol = symbol.getOriginalSymbol();
            return originalSymbol != null && set.contains(originalSymbol);
        }

        @NotNull
        private Set<OCSymbol> collectSameSymbols(@NotNull OCSymbol symbol, @NotNull Project project) {
            CommonProcessors.CollectProcessor sameSymbolCollector = new CommonProcessors.CollectProcessor(new HashSet());
            symbol.processSameSymbols((Processor<OCSymbol>)sameSymbolCollector, project);
            return (Set)sameSymbolCollector.getResults();
        }

        protected ResolveResult @NotNull [] resolveInner(boolean incompleteCode, @NotNull PsiFile containingFile) {
            List<OCMethodSymbol> responders = this.resolveToSymbols();
            ArrayList<PsiElementResolveResult> answer = new ArrayList<PsiElementResolveResult>();
            for (OCMethodSymbol responder : responders) {
                PsiElement definition = responder.locateDefinition(OCSendMessageExpressionImpl.this.getProject());
                if (definition == null) continue;
                answer.add(new PsiElementResolveResult(definition, true));
            }
            return answer.toArray(ResolveResult.EMPTY_ARRAY);
        }

        @NotNull
        public PsiElement getElement() {
            return OCSendMessageExpressionImpl.this;
        }

        @NotNull
        public TextRange getRangeInElement() {
            return ReferenceRange.getRange((PsiReference)this);
        }

        @NotNull
        public List<TextRange> getRanges() {
            ArrayList<TextRange> answer = new ArrayList<TextRange>();
            int parentOffset = -this.getElement().getTextRange().getStartOffset();
            for (OCMessageArgument argument : OCSendMessageExpressionImpl.this.getArguments()) {
                TextRange argumentRange;
                PsiElement id = argument.getArgumentSelector().getSelectorIdentifier();
                if (id == null || (argumentRange = id.getTextRange()).isEmpty()) continue;
                answer.add(argumentRange.shiftRight(parentOffset));
            }
            return answer;
        }

        @NotNull
        public String getCanonicalText() {
            return OCSendMessageExpressionImpl.this.getMessageSelector();
        }

        public PsiElement handleElementRename(@NotNull String newName) throws IncorrectOperationException {
            PsiElement identifier = OCSendMessageExpressionImpl.this.getArguments().get(0).getArgumentSelector().getSelectorIdentifier();
            if (identifier != null) {
                return identifier.replace(OCElementFactory.createIdentifier(newName, OCSendMessageExpressionImpl.this));
            }
            return OCSendMessageExpressionImpl.this;
        }

        @Override
        public PsiElement bindToSymbol(@NotNull OCSymbol symbol) {
            String newSelector = symbol.getName();
            if (symbol instanceof OCPropertySymbol) {
                newSelector = OCNameSuggester.isObjCGetter(OCSendMessageExpressionImpl.this.getMessageSelector()) ? ((OCPropertySymbol)symbol).getGetterName() : ((OCPropertySymbol)symbol).getSetterName();
            } else assert (symbol instanceof OCMethodSymbol) : symbol.getClass();
            if (!OCSendMessageExpressionImpl.this.getMessageSelector().equals(newSelector)) {
                this.handleElementRename(newSelector);
            }
            return this.getElement();
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            Object symbol = ((OCSymbolDeclarator)element).getSymbol();
            return symbol != null ? this.bindToSymbol((OCSymbol)symbol) : element;
        }
    }
}

