/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCPrefixExpression;
import com.jetbrains.cidr.lang.psi.impl.OCExpressionWithReferenceBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCPrefixExpressionImpl
extends OCExpressionWithReferenceBase<OCOperatorReference>
implements OCPrefixExpression {
    public OCPrefixExpressionImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    @Nullable
    protected OCOperatorReference createReference() {
        String name = this.getOperationSign().getName();
        OCExpression operand = this.getOperand();
        if (operand != null) {
            return new OCOperatorReference((PsiElement)this, name, OCOperatorReference.OperatorPlacement.PREFIX, this.getOperationSignNode().getPsi(), operand);
        }
        return null;
    }

    @Override
    public OCExpression getOperand() {
        return (OCExpression)this.findChildByType(OCElementTypes.EXPRESSIONS);
    }

    @Override
    @NotNull
    public OCElementType getOperationSign() {
        return (OCElementType)this.getOperationSignNode().getElementType();
    }

    @Override
    @NotNull
    public ASTNode getOperationSignNode() {
        return this.getNode().getFirstChildNode();
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitPrefixExpression(this);
    }

    @Override
    @NotNull
    protected OCType getType(@NotNull OCResolveContext context) {
        OCExpression op;
        OCOperatorReference reference = (OCOperatorReference)this.getReference();
        if (reference != null) {
            for (OCSymbol operator : reference.resolveToSymbols(context)) {
                if (!(operator instanceof OCFunctionSymbol)) continue;
                return ((OCFunctionSymbol)operator).getEffectiveType(this);
            }
        }
        return (op = this.getOperand()) != null ? op.getResolvedType(context) : OCUnknownType.INSTANCE;
    }
}

