/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCLambdaIntroducer;
import com.jetbrains.cidr.lang.psi.OCLocalScopeable;
import com.jetbrains.cidr.lang.psi.OCNoexceptSpecifier;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.impl.OCExpressionBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCCallableKind;
import com.jetbrains.cidr.lang.symbols.DeclarationContext;
import com.jetbrains.cidr.lang.symbols.OCBuilderDriver;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolReferenceResolver;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.expression.OCLambdaExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCLambdaExpressionImpl
extends OCExpressionBase
implements OCLambdaExpression {
    public OCLambdaExpressionImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public OCCallableKind getKind() {
        return OCCallableKind.LAMBDA;
    }

    @Override
    @NotNull
    public OCType getReturnType() {
        OCTypeElement typeElement = this.getReturnTypeElement();
        return typeElement != null ? typeElement.getType() : this.getReturnType(false, OCResolveContext.forPsi(this));
    }

    public List<OCDeclarator> getParameters() {
        OCParameterList parameterList = this.getParameterList();
        return parameterList != null ? parameterList.getParameters() : null;
    }

    @Override
    @Nullable
    public OCNoexceptSpecifier getNoexceptSpecifier() {
        return (OCNoexceptSpecifier)this.findChildByType((IElementType)OCElementTypes.CPP_NOEXCEPT_SPECIFIER);
    }

    @Override
    public OCSymbol getSymbol() {
        OCBuilderDriver<ASTNode> builderDriver = OCBuilderDriver.createForASTNode(this.getNode(), this.getContainingOCFile());
        PsiElement scope = PsiTreeUtil.getContextOfType((PsiElement)this, (Class[])new Class[]{OCLocalScopeable.class});
        OCSymbolWithQualifiedName parent = OCSymbolReferenceResolver.getGlobalContextFromLocal(this);
        return builderDriver.getExpressionSymbol(this.getNode(), new DeclarationContext(null, scope, parent, null, this, false));
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public OCLambdaIntroducer getLambdaIntroducer() {
        return (OCLambdaIntroducer)this.findChildByType((IElementType)OCElementTypes.CPP_LAMBDA_INTRODUCER);
    }

    @Override
    @NotNull
    protected OCType getType(@NotNull OCResolveContext context) {
        OCTypeElement typeElement;
        OCType returnType;
        OCParameterList params = this.getParameterList();
        ArrayList<OCType> paramTypes = new ArrayList<OCType>();
        ArrayList<String> paramNames = new ArrayList<String>();
        if (params != null) {
            for (OCParameterDeclaration parameterDeclaration : params.getParameterDeclarations()) {
                OCDeclarator paramDeclarator = parameterDeclaration.getDeclarator();
                if (paramDeclarator == null) continue;
                paramTypes.add(paramDeclarator.getType());
                paramNames.add(paramDeclarator.getName());
            }
        }
        OCType oCType = returnType = (typeElement = this.getReturnTypeElement()) != null ? typeElement.getType() : this.getReturnType(true, context);
        if (returnType instanceof OCAutoType && ((OCAutoType)returnType).needsAutoParamsResolving()) {
            return returnType;
        }
        return OCPointerType.to(new OCFunctionType(returnType, paramTypes, paramNames));
    }

    @Override
    @Nullable
    public OCBlockStatement getBody() {
        return (OCBlockStatement)this.findChildByType(OCElementTypes.BLOCK_STATEMENTS);
    }

    @Override
    public OCTypeElement getReturnTypeElement() {
        return (OCTypeElement)this.findChildByType((IElementType)OCElementTypes.TYPE_ELEMENT);
    }

    @Override
    public OCParameterList getParameterList() {
        return (OCParameterList)this.findChildByType((IElementType)OCElementTypes.PARAMETER_LIST);
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitLambdaExpression(this);
    }

    @NotNull
    private OCType getReturnType(boolean ignoreAutoParams, @NotNull OCResolveContext context) {
        OCType lambdaType;
        OCSymbol symbol = this.getSymbol();
        OCType oCType = lambdaType = symbol instanceof OCLambdaExpressionSymbol ? symbol.getResolvedType(context) : null;
        if (ignoreAutoParams && lambdaType instanceof OCAutoType && ((OCAutoType)lambdaType).needsAutoParamsResolving()) {
            return lambdaType;
        }
        if (lambdaType != null && lambdaType.getTerminalType() instanceof OCFunctionType) {
            return ((OCFunctionType)lambdaType.getTerminalType()).getReturnType();
        }
        return OCUnknownType.INSTANCE;
    }
}

