/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.Language;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.testFramework.LightVirtualFile;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.psi.OCFragmentVirtualFile;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class OCFragmentVirtualFileImpl
extends LightVirtualFile
implements OCFragmentVirtualFile {
    private int myParentOffset;
    private CharSequence myParentFileContent = "";
    private VirtualFile myParent;
    @NonNls
    private static final String FILENAME_SEPARATOR = "_CLION_FRAGMENT_SEPARATOR_";

    public OCFragmentVirtualFileImpl(@NotNull String name) {
        super(name);
    }

    public OCFragmentVirtualFileImpl(@NotNull String name, @NotNull Language language, @NotNull CharSequence text) {
        super(name, language, text);
    }

    public CharSequence getParentFileContent() {
        return this.myParentFileContent;
    }

    public int getParentOffset() {
        return this.myParentOffset;
    }

    public void initWithContext(@NotNull PsiElement context) {
        if (context instanceof OCSymbolHolder) {
            this.myParent = ((OCSymbolHolder)context).getContainingVirtualFile();
        } else {
            this.myParent = context.getContainingFile().getVirtualFile();
            this.myParentFileContent = context.getContainingFile().getViewProvider().getContents();
        }
        this.myParentOffset = context.getTextOffset();
    }

    public VirtualFile getParent() {
        return this.myParent;
    }

    @NotNull
    public String getPath() {
        VirtualFile parent = this.getParent();
        if (parent == null || parent.isDirectory()) {
            return super.getPath();
        }
        VirtualFile dirOfParent = parent.getParent();
        if (dirOfParent == null) {
            OCLog.LOG.warn("Why file doesn't have any parent?");
            return super.getPath();
        }
        return dirOfParent.getPath() + "/" + parent.getName() + FILENAME_SEPARATOR + this.getName();
    }

    public static String getFilenameSeparator() {
        return FILENAME_SEPARATOR;
    }
}

