/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCppUsingStatement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCLocalScopeable;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.impl.OCElementBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.symbols.DeclarationContext;
import com.jetbrains.cidr.lang.symbols.OCBuilderDriver;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbolReferenceResolver;
import com.jetbrains.cidr.lang.symbols.cpp.OCAliasUsingSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCppUsingStatementImpl
extends OCElementBase
implements OCCppUsingStatement {
    public OCCppUsingStatementImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public boolean isNamespaceUsing() {
        return this.findChildByType((IElementType)OCTokenTypes.NAMESPACE_CPP_KEYWORD) != null;
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        PsiElement ident = this.findChildByType((IElementType)OCTokenTypes.IDENTIFIER);
        if (ident == null) {
            OCReferenceElement ref = (OCReferenceElement)this.findChildByType((IElementType)OCElementTypes.REFERENCE_ELEMENT);
            return ref != null ? ref.getLastChild() : null;
        }
        return ident;
    }

    public String getName() {
        PsiElement nameIdentifier = this.getNameIdentifier();
        return nameIdentifier != null ? nameIdentifier.getText() : null;
    }

    @Override
    public int getTextOffset() {
        return OCSymbolOffsetUtil.getTextOffset(this.getComplexOffset());
    }

    @Override
    public long getComplexOffset() {
        PsiElement ident = this.getNameIdentifier();
        return ident == null ? super.getComplexOffset() : OCSymbolOffsetUtil.getComplexOffset(ident);
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitUsingStatement(this);
    }

    @Override
    public PsiReference getIdentifierReference() {
        OCReferenceElement referenceElement = (OCReferenceElement)this.findChildByClass(OCReferenceElement.class);
        return referenceElement != null ? referenceElement.getReference() : null;
    }

    @Override
    public OCSymbol getLocalSymbol() {
        OCFile file = this.getContainingOCFile();
        PsiElement scope = PsiTreeUtil.getContextOfType((PsiElement)this, (Class[])new Class[]{OCLocalScopeable.class});
        OCSymbolWithQualifiedName parent = OCSymbolReferenceResolver.getGlobalContextFromLocal(this);
        DeclarationContext declarationContext = new DeclarationContext(null, scope, parent, null, scope != null ? this : null, false);
        CommonProcessors.FindFirstProcessor<OCSymbol> finder = new CommonProcessors.FindFirstProcessor<OCSymbol>(){

            protected boolean accept(OCSymbol symbol) {
                return symbol instanceof OCUsingSymbol || symbol instanceof OCAliasUsingSymbol;
            }
        };
        OCBuilderDriver<ASTNode> builderDriver = OCBuilderDriver.createForASTNode(this.getNode(), file, (Processor<OCSymbol>)finder);
        builderDriver.processUsingStatement(this.getNode(), (Processor<OCSymbol>)finder, declarationContext);
        return (OCSymbol)finder.getFoundValue();
    }

    @Override
    public OCSymbol getSymbol() {
        OCSymbol symbol = this.getContainingOCFile().findSymbol(this, OCSymbol.class);
        return symbol != null ? symbol : this.getLocalSymbol();
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        OCElementUtil.replaceWithIdentifier(this.getNameIdentifier(), name, this);
        return this;
    }
}

