/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCCppNewExpression;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.impl.OCExpressionBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCppNewExpressionImpl
extends OCExpressionBase
implements OCCppNewExpression {
    public OCCppNewExpressionImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    public OCType getResolvedType(@NotNull OCResolveContext context) {
        OCTypeElement type = (OCTypeElement)this.findChildByClass(OCTypeElement.class);
        if (type == null) {
            return super.getType(context);
        }
        boolean isListInitialization = this.getInitializerList() != null;
        OCArgumentsList<OCExpression> arguments = OCArgumentsList.getArgumentList(this.getInitializers());
        return OCCppNewExpressionImpl.getNewExprType(type.getType().resolve(context), arguments, isListInitialization, type.getArrayLengths(), context, this.getContainingFile().getVirtualFile(), this.getComplexOffset());
    }

    @NotNull
    public static OCType getNewExprType(@NotNull OCType type, OCArgumentsList<?> arguments, boolean isListInitialization, int arrayLengths, @NotNull OCResolveContext context, @Nullable VirtualFile file, long complexOffset) {
        if (type instanceof OCStructType && arrayLengths == 0) {
            return OCPointerType.to(OCTypeUtils.deduceClassTemplateArguments((OCStructType)type, null, arguments, isListInitialization, context, file, complexOffset));
        }
        if (arguments.getCount() == 1 && !type.isCompatible(arguments.getTypes().get(0), context)) {
            return OCUnknownType.INSTANCE;
        }
        for (int i = 0; i < arrayLengths && type instanceof OCPointerType; ++i) {
            type = ((OCPointerType)type).getRefType();
        }
        return OCPointerType.to(type);
    }

    @Override
    @Nullable
    public OCTypeElement getConstructingTypeElement() {
        return (OCTypeElement)this.findChildByType((IElementType)OCElementTypes.TYPE_ELEMENT);
    }

    @Override
    @Nullable
    public OCReferenceElement getReferenceElement() {
        OCTypeElement typeElement = this.getConstructingTypeElement();
        ASTNode node = typeElement != null ? typeElement.getNode().findChildByType((IElementType)OCElementTypes.REFERENCE_ELEMENT) : null;
        return node != null ? (OCReferenceElement)node.getPsi() : null;
    }

    @Override
    @NotNull
    public OCType getConstructingType() {
        OCTypeElement typeElement = this.getConstructingTypeElement();
        return typeElement != null ? typeElement.getType() : OCUnknownType.INSTANCE;
    }

    @Override
    @Nullable
    public OCArgumentList getArgumentList() {
        OCTypeElement typeElement = this.getConstructingTypeElement();
        for (PsiElement child = this.getLastChild(); child != null && child != typeElement; child = child.getPrevSibling()) {
            if (!(child instanceof OCArgumentList)) continue;
            return (OCArgumentList)child;
        }
        return null;
    }

    @Override
    @NotNull
    public List<OCExpression> getArguments() {
        OCArgumentList argumentList = this.getArgumentList();
        return argumentList != null ? argumentList.getArguments() : Collections.emptyList();
    }

    @Override
    @Nullable
    public OCCompoundInitializer getInitializerList() {
        OCTypeElement typeElement = this.getConstructingTypeElement();
        for (PsiElement child = this.getLastChild(); child != null && child != typeElement; child = child.getPrevSibling()) {
            if (!(child instanceof OCCompoundInitializer)) continue;
            return (OCCompoundInitializer)child;
        }
        return null;
    }

    @Override
    @NotNull
    public List<OCExpression> getInitializers() {
        OCArgumentList argumentList = this.getArgumentList();
        if (argumentList != null) {
            return argumentList.getArguments();
        }
        OCCompoundInitializer initializerList = this.getInitializerList();
        return initializerList != null ? initializerList.getInitializerExpressions() : Collections.emptyList();
    }

    @Override
    public boolean isNoThrow() {
        OCTypeElement typeElement = this.getConstructingTypeElement();
        if (typeElement == null) {
            return false;
        }
        PsiElement firstChild = this.getFirstChild();
        for (PsiElement element = typeElement.getPrevSibling(); element != null && element != firstChild; element = element.getPrevSibling()) {
            if (!(element instanceof OCArgumentList)) continue;
            List<OCExpression> arguments = ((OCArgumentList)element).getArguments();
            for (OCExpression argument : arguments) {
                String typeName;
                OCType argumentType = argument.getResolvedType();
                if (!(argumentType instanceof OCStructType) || !(typeName = ((OCStructType)argumentType).getSymbol().getName()).equals("nothrow_t")) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitCppNewExpression(this);
    }
}

