/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.clang.ExternalResolveUtils;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCPolyVariantReference;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCTypeArgumentList;
import com.jetbrains.cidr.lang.psi.impl.OCElementWithReferenceBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.refactoring.util.OCBindUtil;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.resolve.references.OCPolyVariantReferenceImpl;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCAliasUsingSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceAliasSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityAfterResolvingVisitor;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCppNamespaceQualifierImpl
extends OCElementWithReferenceBase<OCPolyVariantReference<OCSymbol>>
implements OCCppNamespaceQualifier {
    public OCCppNamespaceQualifierImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    @Nullable
    public OCCppNamespaceQualifier getNamespaceQualifier() {
        return (OCCppNamespaceQualifier)this.findChildByType((IElementType)OCElementTypes.CPP_NAMESPACE_QUALIFIER);
    }

    @Override
    @Nullable
    public OCExpression getDecltypeExpression() {
        if (this.findChildByType((IElementType)OCTokenTypes.DECLTYPE_CPP_KEYWORD) != null) {
            return (OCExpression)this.findChildByType(OCElementTypes.EXPRESSIONS);
        }
        return null;
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        return this.findNameStartTokenInCall();
    }

    public TextRange getRangeInElement() {
        PsiElement referenceToken = this.getNameIdentifier();
        if (referenceToken != null) {
            return TextRange.from((int)referenceToken.getStartOffsetInParent(), (int)referenceToken.getTextLength());
        }
        return TextRange.EMPTY_RANGE;
    }

    @Override
    @Nullable
    public OCTypeArgumentList getTemplateArgumentList() {
        return (OCTypeArgumentList)this.findChildByType((IElementType)OCElementTypes.TEMPLATE_ARGUMENT_LIST);
    }

    public String getName() {
        PsiElement identifier = this.getNameIdentifier();
        return identifier != null ? identifier.getText() : null;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        OCElementUtil.replaceWithIdentifier(this.getNameIdentifier(), name, this);
        return this;
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitNamespaceQualifier(this);
    }

    @Override
    @NotNull
    public List<OCSymbol> resolveToSymbols() {
        return this.resolveToSymbols(OCResolveContext.forPsi(this));
    }

    @Override
    @NotNull
    public Collection<OCSymbol> resolveTemplateDeclarations() {
        return OCResolveUtil.resolveTemplateDeclarations(this);
    }

    @Override
    @NotNull
    public List<OCSymbol> resolveToSymbols(@NotNull OCResolveContext context) {
        OCSymbol sym;
        Object thisRef;
        ArrayList<OCSymbol> result = new ArrayList<OCSymbol>();
        OCCommonProcessors.OrderedProcessor processor2 = new OCCommonProcessors.OrderedProcessor(ocSymbol -> {
            if (ocSymbol instanceof OCNamespaceSymbol) {
                if (ocSymbol.isPredeclaration()) {
                    if (result.size() == 0) {
                        result.add((OCSymbol)ocSymbol);
                    }
                } else {
                    result.add((OCSymbol)ocSymbol);
                }
            }
            if (ocSymbol instanceof OCNamespaceAliasSymbol) {
                if (result.size() == 0) {
                    result.add((OCSymbol)ocSymbol);
                }
            } else if (ocSymbol instanceof OCTypeParameterSymbol || ocSymbol instanceof OCDeclaratorSymbol || ocSymbol instanceof OCAliasUsingSymbol) {
                result.add((OCSymbol)ocSymbol);
            }
            return true;
        }, OCSymbol.NON_PREDEFINITION_CONDITION, Conditions.alwaysTrue());
        PsiElement parent = this.getParent();
        while (parent instanceof OCCppNamespaceQualifier) {
            parent = parent.getParent();
        }
        OCSymbolReference.LocalReference ref = OCSymbolReference.getLocalReference(this, OCSymbolReference.SymbolKindFilter.ONLY_NAMESPACE_LIKE);
        List<OCSymbol> symbols = ref.resolveToSymbols(false, true, true, context);
        if (symbols.isEmpty()) {
            symbols = ref.resolveToSymbols(false, true, false, context);
        }
        if ((thisRef = this.getReference()) != null && (sym = ExternalResolveUtils.resolveSymbol(thisRef)) != null) {
            symbols = new ArrayList<OCSymbol>(symbols);
            symbols.add(sym);
        }
        ContainerUtil.process(symbols, processor2);
        processor2.finish();
        if (result.isEmpty() && this.getContainingOCFile().isInLibraries()) {
            OCResolveContext context2 = OCResolveContext.forPsi(this);
            context2.setProcessNonImported(true);
            ContainerUtil.process(context2.resolveToSymbols(ref, false, true), processor2);
            processor2.finish();
        }
        return result;
    }

    @Override
    @Nullable
    public OCSymbol getPredeclarationInParent(OCSymbolWithQualifiedName symbol, boolean checkTypes) {
        OCResolveContext context = OCResolveContext.forPsi(this);
        OCType resolvedType = symbol.getResolvedType(context);
        OCTypeEqualityAfterResolvingVisitor stongEqualer = new OCTypeEqualityAfterResolvingVisitor(resolvedType, true, false, true, true, context);
        OCTypeEqualityAfterResolvingVisitor weakEqualer = new OCTypeEqualityAfterResolvingVisitor(resolvedType, true, true, true, true, context);
        CommonProcessors.FindFirstProcessor<OCSymbol> finder = new CommonProcessors.FindFirstProcessor<OCSymbol>(){

            protected boolean accept(OCSymbol symbol) {
                return !(symbol instanceof OCSymbolWithQualifiedName) || !((OCSymbolWithQualifiedName)symbol).isFriend();
            }
        };
        OCCommonProcessors.OrderedProcessor processor2 = new OCCommonProcessors.OrderedProcessor(finder, (Condition<? super T>[])new Condition[]{predeclaration -> {
            if (checkTypes && predeclaration instanceof OCFunctionSymbol) {
                OCType symbolType = predeclaration.getType().resolve(OCResolveContext.forSymbol(predeclaration, this.getProject()));
                return stongEqualer.equal(symbolType);
            }
            return true;
        }, predeclaration -> {
            if (checkTypes && predeclaration instanceof OCFunctionSymbol) {
                OCType symbolType = predeclaration.getType().resolve(OCResolveContext.forSymbol(predeclaration, this.getProject()));
                return weakEqualer.isFunctionSignatureEqual(symbolType);
            }
            return true;
        }});
        for (OCSymbol parentSymbol : this.resolveToSymbols()) {
            OCType type;
            if (parentSymbol.getKind() == OCSymbolKind.TYPEDEF && (type = parentSymbol.getResolvedType(context)) instanceof OCStructType) {
                for (OCStructSymbol parentSymbolPart : ((OCStructType)type).getStructs()) {
                    parentSymbolPart.processMembers(symbol.getName(), processor2);
                }
            }
            if (!(parentSymbol instanceof OCNamespaceSymbol)) continue;
            ((OCNamespaceSymbol)parentSymbol).processMembers(symbol.getName(), processor2);
        }
        processor2.finish();
        return (OCSymbol)finder.getFoundValue();
    }

    @Override
    @Nullable
    protected OCPolyVariantReference<OCSymbol> createReference() {
        return new OCPolyVariantReferenceImpl<OCSymbol>(){

            @Override
            @NotNull
            public List<OCSymbol> resolveToSymbols() {
                return OCCppNamespaceQualifierImpl.this.resolveToSymbols();
            }

            @Override
            @NotNull
            public List<OCSymbol> resolveToSymbols(@NotNull OCResolveContext context) {
                return OCCppNamespaceQualifierImpl.this.resolveToSymbols(context);
            }

            @NotNull
            public PsiElement getElement() {
                return OCCppNamespaceQualifierImpl.this;
            }

            @NotNull
            public TextRange getRangeInElement() {
                return OCCppNamespaceQualifierImpl.this.getRangeInElement();
            }

            @NotNull
            public String getCanonicalText() {
                String name = OCCppNamespaceQualifierImpl.this.getName();
                return name != null ? name : "";
            }

            public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
                return OCCppNamespaceQualifierImpl.this.setName(newElementName);
            }

            @Override
            public PsiElement bindToSymbol(@NotNull OCSymbol symbol) {
                List symbols = ((OCPolyVariantReference)OCCppNamespaceQualifierImpl.this.getReference()).resolveToSymbols();
                if (symbols.contains(symbol)) {
                    return OCCppNamespaceQualifierImpl.this;
                }
                if (!(symbol instanceof OCSymbolWithQualifiedName)) {
                    return OCCppNamespaceQualifierImpl.this;
                }
                OCQualifiedName qualifiedName = ((OCSymbolWithQualifiedName)symbol).getResolvedQualifiedName(OCResolveContext.forPsi(OCCppNamespaceQualifierImpl.this));
                if (qualifiedName != null) {
                    OCBindUtil.setShortestPossibleName(qualifiedName, OCCppNamespaceQualifierImpl.this, (OCSymbolWithQualifiedName)symbol);
                }
                return OCCppNamespaceQualifierImpl.this;
            }

            public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
                Object symbol = ((OCSymbolDeclarator)element).getSymbol();
                return symbol != null ? this.bindToSymbol((OCSymbol)symbol) : element;
            }

            public boolean isSoft() {
                return false;
            }
        };
    }
}

