/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCategoryName;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCInstanceVariablesList;
import com.jetbrains.cidr.lang.psi.OCInterface;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCProtocol;
import com.jetbrains.cidr.lang.psi.OCProtocolList;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCSuperClassRef;
import com.jetbrains.cidr.lang.psi.OCSynthesizePropertiesList;
import com.jetbrains.cidr.lang.psi.impl.OCElementWithReferenceBase;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import com.jetbrains.cidr.lang.util.OCDeclarationKind;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCClassDeclarationBaseImpl<T extends OCClassSymbol>
extends OCElementWithReferenceBase
implements OCClassDeclaration<T> {
    public OCClassDeclarationBaseImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    public OCSuperClassRef getSuperClassRef() {
        return (OCSuperClassRef)this.findNotNullChildByType((IElementType)OCElementTypes.SUPER_CLASS_REF);
    }

    @Override
    @NotNull
    public OCProtocolList getProtocolList() {
        return (OCProtocolList)this.findNotNullChildByType((IElementType)OCElementTypes.PROTOCOL_LIST);
    }

    @Override
    @NotNull
    public List<OCMethod> getMethods() {
        return this.findChildrenByType((IElementType)OCElementTypes.METHOD);
    }

    @Override
    @NotNull
    public List<OCProperty> getProperties() {
        return this.findChildrenByType((IElementType)OCElementTypes.PROPERTY);
    }

    @Override
    @NotNull
    public List<OCSynthesizePropertiesList> getSynthesizes() {
        return this.findChildrenByType((IElementType)OCElementTypes.SYNTHESIZED_PROPERTIES_LIST);
    }

    @Nullable
    protected PsiReference createReference() {
        return null;
    }

    @Override
    public String getName() {
        PsiElement name = this.getNameIdentifier();
        return name != null ? name.getText() : null;
    }

    @Override
    @Nullable
    public String getCanonicalName() {
        return OCCodeInsightUtil.getClassNameWithCategory(this.getName(), this.getCategory());
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        for (ASTNode node = this.getNode().getFirstChildNode(); node != null; node = node.getTreeNext()) {
            IElementType tt = node.getElementType();
            if (tt == OCTokenTypes.IDENTIFIER) {
                return node.getPsi();
            }
            if (tt != OCTokenTypes.LPAR) continue;
            return null;
        }
        return null;
    }

    @Override
    public int getTextOffset() {
        return OCSymbolOffsetUtil.getTextOffset(this.getComplexOffset());
    }

    @Override
    public long getComplexOffset() {
        PsiElement ident = this.getNameIdentifier();
        return ident == null ? super.getComplexOffset() : OCSymbolOffsetUtil.getComplexOffset(ident);
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        int categoryIdx = name.indexOf(43);
        if (categoryIdx != -1) {
            OCCategoryName categoryName = this.getCategoryElement();
            if (categoryName != null) {
                categoryName.setName(name.substring(categoryIdx + 1));
            }
            name = name.substring(0, categoryIdx);
        }
        OCElementUtil.replaceWithIdentifier(this.getNameIdentifier(), name, this);
        return this;
    }

    @Override
    @Nullable
    public String getCategory() {
        OCCategoryName categoryName = this.getCategoryElement();
        return categoryName != null ? categoryName.getName() : null;
    }

    @Override
    @Nullable
    public OCCategoryName getCategoryElement() {
        return (OCCategoryName)this.findChildByType((IElementType)OCElementTypes.CATEGORY_NAME);
    }

    @Override
    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            public String getPresentableText() {
                return OCCodeInsightUtil.getClassNameWithCategory(OCClassDeclarationBaseImpl.this.getName(), OCClassDeclarationBaseImpl.this.getCategory());
            }

            public String getLocationString() {
                String framework = OCClassDeclarationBaseImpl.frameworkNameForFile(OCClassDeclarationBaseImpl.this.getContainingFile().getVirtualFile());
                return framework.length() == 0 ? OCClassDeclarationBaseImpl.this.getContainingFile().getVirtualFile().getName() : framework;
            }

            public Icon getIcon(boolean open) {
                return OCClassDeclarationBaseImpl.this.getIcon(0);
            }
        };
    }

    private static String frameworkNameForFile(VirtualFile file) {
        StringBuilder builder2 = new StringBuilder();
        while (file != null) {
            if ("framework".equals(file.getExtension())) {
                if (builder2.length() > 0) {
                    builder2.insert(0, "::");
                }
                builder2.insert(0, file.getNameWithoutExtension());
            }
            file = file.getParent();
        }
        return builder2.toString();
    }

    @Override
    public OCObjectType getType(boolean ignoreImports) {
        OCType type = OCReferenceType.resolvedFromText(this.getName(), OCResolveContext.forPsi(this), ignoreImports);
        return type instanceof OCObjectType ? (OCObjectType)type : null;
    }

    @Override
    @Nullable
    public OCObjectType getType() {
        return this.getType(false);
    }

    @Override
    public T getSymbol() {
        return (T)this.getContainingOCFile().findSymbol(this, this.getSymbolClass());
    }

    protected Class<? extends OCClassSymbol> getSymbolClass() {
        return OCClassSymbol.class;
    }

    @Override
    public List<OCClassDeclaration> getSuperTypes() {
        OCObjectType type = this.getType();
        if (type == null) {
            return Collections.emptyList();
        }
        OCObjectType superType = type.getSuperType();
        ArrayList<OCClassDeclaration> answer = new ArrayList<OCClassDeclaration>();
        if (superType != null) {
            OCClassDeclarationBaseImpl.appendSymbol(answer, superType.getClassSymbol(), this.getProject());
        }
        if (this instanceof OCProtocol) {
            this.appendProtocols(answer, (OCClassSymbol)this.getSymbol());
        } else {
            this.appendProtocols(answer, type.getClassSymbol());
        }
        for (OCInterfaceSymbol category : type.getCategoryInterfaces()) {
            this.appendProtocols(answer, category);
        }
        return answer;
    }

    private static void appendSymbol(List<OCClassDeclaration> answer, @Nullable OCSymbol symbol, @NotNull Project project) {
        PsiElement def;
        if (symbol != null && (def = symbol.locateDefinition(project)) instanceof OCClassDeclaration) {
            answer.add((OCClassDeclaration)def);
        }
    }

    private void appendProtocols(List<OCClassDeclaration> answer, @Nullable OCClassSymbol symbol) {
        if (symbol != null) {
            for (String protocolName : symbol.getProtocolNames()) {
                CommonProcessors.FindFirstProcessor resolver = new CommonProcessors.FindFirstProcessor();
                OCResolveUtil.processGlobalSymbols(protocolName, this, new OCCommonProcessors.TypeFilteredProcessor((Processor<OCProtocolSymbol>)resolver, OCProtocolSymbol.class));
                if (!resolver.isFound()) continue;
                OCClassDeclarationBaseImpl.appendSymbol(answer, (OCSymbol)resolver.getFoundValue(), this.getProject());
            }
        }
    }

    @Override
    public OCInterface getSuperClass() {
        OCObjectType type = this.getType();
        if (type == null) {
            return null;
        }
        OCObjectType superType = type.getSuperType();
        if (superType == null) {
            return null;
        }
        OCClassSymbol superSymbol = superType.getClassSymbol();
        if (superSymbol == null) {
            return null;
        }
        PsiElement sup = superSymbol.locateDefinition(this.getProject());
        return sup instanceof OCInterface ? (OCInterface)sup : null;
    }

    @Override
    public List<OCSymbol> getSuperSymbols() {
        OCObjectType type = this.getType();
        if (type == null) {
            return Collections.emptyList();
        }
        OCProtocolList protocolList = this.getProtocolList();
        ArrayList<OCSymbol> supers = new ArrayList<OCSymbol>();
        for (OCReferenceElement protocolRef : protocolList.getProtocols()) {
            OCSymbol symbol = protocolRef.resolveToSymbol();
            if (!(symbol instanceof OCProtocolSymbol)) continue;
            supers.add(symbol);
        }
        OCObjectType superType = type.getSuperType();
        if (superType != null) {
            OCClassSymbol superSymbol;
            OCClassSymbol oCClassSymbol = superSymbol = this instanceof OCImplementation ? superType.getImplementation() : superType.getInterface();
            if (superSymbol == null) {
                superSymbol = superType.getClassSymbol();
            }
            if (superSymbol != null) {
                supers.add(superSymbol);
            }
        }
        return supers;
    }

    @Override
    @NotNull
    public OCInstanceVariablesList getInstanceVariablesList() {
        return (OCInstanceVariablesList)this.findNotNullChildByType((IElementType)OCElementTypes.INSTANCE_VARIABLES_LIST);
    }

    private int getMethodsStartOffset() {
        return this.getMethodsStartOffset(false);
    }

    @Override
    public int getMethodsStartOffset(boolean includeAdjacentWhitespaces) {
        int minOffset = -1;
        for (OCDeclarationKind kind : OCDeclarationKind.ourMethodKinds) {
            int offset = kind.getChildrenStartOffset(this, includeAdjacentWhitespaces);
            if (minOffset != -1 && minOffset <= offset) continue;
            minOffset = offset;
        }
        return minOffset;
    }

    private int getMethodsEndOffset() {
        return this.getMethodsEndOffset(false);
    }

    @Override
    public int getMethodsEndOffset(boolean includeAdjacentWhitespaces) {
        int maxOffset = -1;
        for (OCDeclarationKind kind : OCDeclarationKind.ourMethodKinds) {
            int offset = kind.getChildrenStartOffset(this, includeAdjacentWhitespaces);
            if (maxOffset != -1 && maxOffset >= offset) continue;
            maxOffset = offset;
        }
        return maxOffset;
    }

    @Override
    public int getMethodsInsertPosition(boolean preferStart, PsiElement at, int caretOffset) {
        int defaultOffset;
        int n = defaultOffset = preferStart ? this.getMethodsStartOffset() : this.getMethodsEndOffset();
        if (caretOffset == -1) {
            return defaultOffset;
        }
        while (at != null && !Comparing.equal((Object)at.getContext(), (Object)this)) {
            at = at.getContext();
        }
        if (at != null && caretOffset >= this.getMethodsStartOffset(true)) {
            TextRange textRange = at.getTextRange();
            if (OCTokenTypes.WHITESPACES.contains(OCElementUtil.getElementType(at)) && textRange.contains(caretOffset)) {
                return caretOffset;
            }
            if (OCElementUtil.isWhitespace(at) && OCElementUtil.getElementType(at.getPrevSibling()) == OCTokenTypes.EOL_COMMENT) {
                return textRange.getStartOffset() + 1;
            }
            return textRange.getStartOffset();
        }
        return defaultOffset;
    }

    @Override
    @Nullable
    public PsiElement getBestMemberPlace(final OCMemberSymbol associateMember) {
        OCSymbol classSymbol = this.getSymbol();
        if (classSymbol == null) {
            return null;
        }
        class MyProcessor
        implements Processor<OCMemberSymbol> {
            PsiElement candidate = null;
            int bestDistance = Integer.MAX_VALUE;

            MyProcessor() {
            }

            public boolean process(OCMemberSymbol symbol) {
                CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
                associateMember.getParent().processMembers(symbol.getName(), associateMember.getClass(), finder);
                if (finder.isFound() && !symbol.isSynthetic()) {
                    PsiElement member;
                    int curDistance = ((OCMemberSymbol)finder.getFoundValue()).getOffset() - associateMember.getOffset();
                    for (member = symbol.locateDefinition(OCClassDeclarationBaseImpl.this.getProject()); member != null && member.getParent() != OCClassDeclarationBaseImpl.this; member = member.getParent()) {
                    }
                    if (Math.abs(curDistance) < Math.abs(this.bestDistance) && member != null) {
                        this.bestDistance = curDistance;
                        this.candidate = member;
                    }
                }
                return true;
            }

            PsiElement getCandidate() {
                if (this.candidate != null && this.bestDistance <= 0) {
                    return this.candidate.getNextSibling();
                }
                return this.candidate;
            }
        }
        MyProcessor processor2 = new MyProcessor();
        classSymbol.processMembers(associateMember.getClass(), processor2);
        return processor2.getCandidate();
    }
}

