/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.preprocessor.OCFileUtil;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.workspace.OCPCHCache;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCRootUtil {
    public static boolean isRoot(@NotNull PsiFile file) {
        return OCFileTypeHelpers.isSourceFile((String)file.getName()) && OCRootUtil.isDeclaredInProject(OCFileUtil.getVirtualFile(file), file.getProject());
    }

    public static boolean isNeedToFindRoot(@NotNull PsiFile file) {
        return OCRootUtil.isNeedToFindRoot(OCFileUtil.getVirtualFile(file), file.getProject());
    }

    public static boolean isNeedToFindRoot(@NotNull VirtualFile file, @NotNull Project project) {
        if (!OCInclusionContextUtil.isLongLived(file)) {
            return false;
        }
        String fileName = file.getName();
        if (OCFileTypeHelpers.isNeverNeedToFindRoot((String)fileName)) {
            return false;
        }
        if (OCFileTypeHelpers.isSourceFile((String)fileName)) {
            return !OCRootUtil.isDeclaredInProject(file, project);
        }
        return !OCPCHCache.isPrecompiledHeader((VirtualFile)file, (Project)project);
    }

    private static boolean isDeclaredInProject(@NotNull VirtualFile file, @NotNull Project project) {
        List configurationsForFile = OCWorkspace.getInstance((Project)project).getConfigurationsForFile(file);
        return !configurationsForFile.isEmpty();
    }
}

