/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.lang.ForeignLeafType;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ExternallyAnnotated;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import com.jetbrains.cidr.lang.parser.OCMacroRange;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafType;
import com.jetbrains.cidr.lang.symbols.symtable.OCNamesInterner;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.Nullable;

public class OCMacroForeignLeafElement
extends ForeignLeafPsiElement
implements ExternallyAnnotated {
    private String myMacroName;
    private int myMacroArgumentIndex;
    private TextRange myRangeInMacroArgument;
    private int myOffsetInTopSubstitution;

    public OCMacroForeignLeafElement(OCMacroForeignLeafType type, String text, String macroName, int macroArgumentIndex, TextRange rangeInMacroArgument, int inSubstitutionOffset) {
        super((ForeignLeafType)type, (CharSequence)OCNamesInterner.intern((String)text));
        this.myMacroName = macroName;
        this.myMacroArgumentIndex = macroArgumentIndex;
        this.myRangeInMacroArgument = rangeInMacroArgument;
        this.myOffsetInTopSubstitution = inSubstitutionOffset;
    }

    public int getMacroArgumentIndex() {
        return this.myMacroArgumentIndex;
    }

    public TextRange getRangeInMacroArgument() {
        return this.myRangeInMacroArgument;
    }

    public String getMacroName() {
        return this.myMacroName;
    }

    public int getOffsetInTopSubstitution() {
        return this.myOffsetInTopSubstitution;
    }

    public int getStartOffset() {
        int result = 0;
        OCMacroForeignLeafElement current = this;
        while (current.getTreeParent() != null) {
            result += current.getStartOffsetInParent();
            current = current.getTreeParent();
        }
        return result;
    }

    public TextRange getTextRange() {
        int start = this.getStartOffset();
        return new TextRange(start, start);
    }

    public void copyFromElement(OCMacroForeignLeafElement element) {
        this.myMacroName = element.myMacroName;
        this.myMacroArgumentIndex = element.myMacroArgumentIndex;
        this.myRangeInMacroArgument = element.myRangeInMacroArgument;
        this.myOffsetInTopSubstitution = element.myOffsetInTopSubstitution;
    }

    @Nullable
    public TextRange getAnnotationRegion() {
        OCMacroRange call = OCElementUtil.getRangeInMacroCall((PsiElement)this);
        if (call != null && call.mapsToArguments()) {
            return call.getTextRange();
        }
        return null;
    }
}

