/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.testFramework.LightVirtualFile;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.preprocessor.OCFileUtil;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.preprocessor.OCRootUtil;
import com.jetbrains.cidr.lang.settings.OCResolveContextSettings;
import com.jetbrains.cidr.lang.workspace.OCLibraryFileResolveConfigurationProvider;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveConfigurations;
import java.util.Collection;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCInclusionContextUtil {
    @Contract(value="null -> false", pure=true)
    public static boolean isLongLived(@Nullable VirtualFile fileFromGetVirtualFileCall) {
        return fileFromGetVirtualFileCall != null && !(fileFromGetVirtualFileCall instanceof LightVirtualFile);
    }

    @Nullable
    public static PsiFile findCachedPsiFile(@NotNull VirtualFile file, @NotNull Project project) {
        if (!file.isValid()) {
            return null;
        }
        return PsiManagerEx.getInstanceEx((Project)project).getFileManager().getCachedPsiFile(file);
    }

    public static void resetUserSelectedConfigurations(@NotNull Project project) {
        OCResolveContextSettings.getInstance((Project)project).resetConfigurationPriorities();
    }

    @NotNull
    public static Collection<OCResolveConfiguration> getAllBuildConfigurationsForFile(@NotNull PsiFile file, @Nullable ProgressIndicator progress) {
        PsiFile fileWithResolve = OCLanguageUtils.asFileWithOCResolve(file);
        if (fileWithResolve != null && OCRootUtil.isNeedToFindRoot(file)) {
            return OCImportGraph.getInstance(file.getProject()).getAllHeaderConfigurations(fileWithResolve, progress);
        }
        Collection<OCResolveConfiguration> configurations = OCLibraryFileResolveConfigurationProvider.getConfigurations(file, progress);
        if (configurations != null) {
            return configurations;
        }
        return OCResolveConfigurations.getAllBuildConfigurationsOfTargetsOfFile((VirtualFile)OCFileUtil.getVirtualFile(file), (Project)file.getProject());
    }

    public static String pragmaOnceId(@NotNull VirtualFile vFile) {
        return OCInclusionContextUtil.fileGuard(vFile, "__CIDR_pragma_once");
    }

    public static String inclusionId(@NotNull VirtualFile vFile) {
        return OCInclusionContextUtil.fileGuard(vFile, "__CIDR_included");
    }

    @NonNls
    private static String fileGuard(@NotNull VirtualFile vFile, @NotNull @NonNls String prefix) {
        if (vFile instanceof VirtualFileWithId) {
            return prefix + "_id_" + ((VirtualFileWithId)vFile).getId();
        }
        return prefix + "_path_" + vFile.getPath();
    }
}

