/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.util.FileContentUtilCore;
import com.jetbrains.cidr.lang.preprocessor.OCFileUtil;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfigurationCache;
import com.jetbrains.cidr.lang.settings.OCResolveContextSettings;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTableHelper;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFileActiveConfigurationCache {
    public static void setUserSelectedConfiguration(@NotNull PsiFile psiFile, @Nullable OCResolveConfiguration config) {
        PsiFile contextFile;
        Project project = psiFile.getProject();
        if (config != null) {
            OCResolveContextSettings.getInstance((Project)project).setSelectedConfiguration(config);
        }
        if ((contextFile = FileContextUtil.getContextFile((PsiElement)psiFile)) != null) {
            psiFile = contextFile;
        }
        OCResolveRootAndConfigurationCache.getInstance(project).invalidateFor(OCFileUtil.getVirtualFile(psiFile));
        VirtualFile file = psiFile.getVirtualFile();
        if (file != null) {
            FileContentUtilCore.reparseFiles((VirtualFile[])new VirtualFile[]{file});
        }
    }

    @Nullable
    public static OCResolveConfiguration getActiveConfiguration(@NotNull PsiElement element) {
        Project project = element.getProject();
        if (project.isDefault()) {
            return null;
        }
        PsiFile contextFile = FileContextUtil.getContextFile((PsiElement)element);
        if (contextFile == null) {
            return null;
        }
        VirtualFile virtualFile = OCFileUtil.getVirtualFile(contextFile);
        if (!FileSymbolTableHelper.isSourceFile(virtualFile, project)) {
            return null;
        }
        OCResolveRootAndConfiguration resolveRootAndConfiguration = OCResolveRootAndConfigurationCache.getInstance(project).getResolveRootAndActiveConfigurationSafe(virtualFile);
        if (resolveRootAndConfiguration == null) {
            return null;
        }
        return resolveRootAndConfiguration.getConfiguration();
    }

    @Nullable
    public static OCResolveConfiguration getActiveConfiguration(@NotNull VirtualFile file, @NotNull Project project) {
        if (project.isDefault()) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile == null) {
            return null;
        }
        return OCFileActiveConfigurationCache.getActiveConfiguration((PsiElement)psiFile);
    }
}

