/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.CharSequenceSubSequence;
import com.jetbrains.cidr.lang.preprocessor.OCContextChange;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class OCContextChangeSet {
    @NotNull
    private final String myText;
    @NotNull
    private Int2ObjectOpenHashMap<OCContextChange> myChangeMap;
    private int myLastOffset;
    private boolean myIsUpdated;
    private boolean myUsingOriginalMap;

    private OCContextChangeSet(@NotNull String text, @NotNull Int2ObjectOpenHashMap<OCContextChange> changeMap, boolean isUpdated, int lastOffset, boolean reusingMap) {
        this.myText = text;
        this.myIsUpdated = isUpdated;
        this.myChangeMap = changeMap;
        this.myLastOffset = lastOffset;
        this.myUsingOriginalMap = reusingMap;
    }

    public boolean isUpdated() {
        return this.myIsUpdated;
    }

    @NotNull
    public String getText() {
        return this.myText;
    }

    @Nullable
    public OCContextChange getChange(int offsetAfterInclude) {
        if (offsetAfterInclude > this.myLastOffset) {
            return null;
        }
        return (OCContextChange)this.myChangeMap.get(offsetAfterInclude);
    }

    public void setChange(int offsetAfterInclude, @NotNull OCContextChange change) {
        if (this.myUsingOriginalMap) {
            this.myUsingOriginalMap = false;
            this.myChangeMap = this.myChangeMap.clone();
        }
        if (offsetAfterInclude > this.myLastOffset) {
            this.myLastOffset = offsetAfterInclude;
        }
        this.myChangeMap.put(offsetAfterInclude, (Object)change);
        this.myIsUpdated = true;
    }

    @NotNull
    public static OCContextChangeSet reuse(@NotNull String newText, @Nullable OCContextChangeSet from, int validateFrom, int validateTo) {
        int diffOffset;
        if (from == null) {
            return new OCContextChangeSet(newText, (Int2ObjectOpenHashMap<OCContextChange>)new Int2ObjectOpenHashMap(), true, 0, false);
        }
        if (validateTo < 0) {
            validateTo = newText.length();
        }
        assert (validateFrom >= 0);
        assert (validateTo >= validateFrom && validateTo <= newText.length());
        int oldLastOffset = from.myLastOffset;
        String oldText = from.getText();
        validateTo = Math.min(oldText.length(), Math.min(validateTo, oldLastOffset + 1));
        if (validateTo == (diffOffset = (validateFrom = Math.min(validateTo, Math.min(Math.min(validateFrom, oldText.length()), newText.length()))) + StringUtil.commonPrefixLength((CharSequence)OCContextChangeSet.subSequence(oldText, validateFrom, validateTo), (CharSequence)OCContextChangeSet.subSequence(newText, validateFrom, newText.length())))) {
            return new OCContextChangeSet(newText, from.myChangeMap, false, oldLastOffset, true);
        }
        int[] loRef = new int[]{0};
        Int2ObjectOpenHashMap fromMap = from.myChangeMap.clone();
        fromMap.int2ObjectEntrySet().removeIf(entry -> {
            boolean valid;
            boolean bl = valid = ((OCContextChange)entry.getValue()).getOffset() < diffOffset;
            if (valid && loRef[0] < entry.getIntKey()) {
                loRef[0] = entry.getIntKey();
            }
            return !valid;
        });
        int lastOffset = loRef[0];
        return new OCContextChangeSet(newText, (Int2ObjectOpenHashMap<OCContextChange>)fromMap, true, lastOffset, false);
    }

    @TestOnly
    @NotNull
    public List<OCContextChange> getChanges() {
        ArrayList<OCContextChange> result = new ArrayList<OCContextChange>((Collection<OCContextChange>)this.myChangeMap.values());
        result.sort(Comparator.comparingInt(OCContextChange::getOffset));
        return result;
    }

    private static CharSequence subSequence(CharSequence seq, int start, int end) {
        return new CharSequenceSubSequence(seq, start, end);
    }
}

