/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.CollectionFactory;
import com.jetbrains.cidr.lang.preprocessor.OCContextChange;
import com.jetbrains.cidr.lang.preprocessor.OCContextChangeBuilder;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public final class OCContextChangeBuilderImpl
implements OCContextChange,
OCContextChangeBuilder {
    private final int myOffset;
    @NotNull
    private final Map<String, OCMacroSymbol> myDefinitions = CollectionFactory.createSmallMemoryFootprintMap();
    @NotNull
    private final Set<String> myUndefs = new HashSet<String>();
    @NotNull
    private final List<OCSymbol> mySymbols = new ArrayList<OCSymbol>();
    @NotNull
    private final Set<VirtualFile> myProcessedFiles = new HashSet<VirtualFile>();

    public OCContextChangeBuilderImpl(int offset) {
        this.myOffset = offset;
    }

    @Override
    public void define(@NotNull String name, @NotNull OCMacroSymbol macro) {
        this.myUndefs.remove(name);
        this.myDefinitions.put(name, macro);
    }

    @Override
    public void undef(@NotNull String name) {
        this.myDefinitions.remove(name);
        this.myUndefs.add(name);
    }

    @Override
    public void addSymbol(@NotNull OCSymbol symbol) {
        this.mySymbols.add(symbol);
    }

    @Override
    public void addProcessedFile(@NotNull VirtualFile file) {
        this.myProcessedFiles.add(file);
    }

    @Override
    public int getOffset() {
        return this.myOffset;
    }

    @Override
    public void apply(@NotNull OCInclusionContext context) {
        int counter = 0;
        for (OCMacroSymbol macro : this.myDefinitions.values()) {
            if (++counter % 256 == 0) {
                ProgressManager.checkCanceled();
            }
            context.define(macro);
        }
        for (String name : this.myUndefs) {
            if (++counter % 256 == 0) {
                ProgressManager.checkCanceled();
            }
            context.undef(name);
        }
        context.preprocessFile(null, null, 1, -1, -1, this.mySymbols, null);
        for (VirtualFile file : this.myProcessedFiles) {
            context.addProcessedFile(file);
        }
    }

    @TestOnly
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OCContextChangeBuilderImpl builder2 = (OCContextChangeBuilderImpl)o;
        if (this.myOffset != builder2.myOffset) {
            return false;
        }
        if (!this.myDefinitions.equals(builder2.myDefinitions)) {
            return false;
        }
        if (!this.myProcessedFiles.equals(builder2.myProcessedFiles)) {
            return false;
        }
        if (!this.mySymbols.equals(builder2.mySymbols)) {
            return false;
        }
        return this.myUndefs.equals(builder2.myUndefs);
    }

    @TestOnly
    public int hashCode() {
        int result = this.myOffset;
        result = 31 * result + this.myDefinitions.hashCode();
        result = 31 * result + this.myUndefs.hashCode();
        result = 31 * result + this.mySymbols.hashCode();
        result = 31 * result + this.myProcessedFiles.hashCode();
        return result;
    }
}

