/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.navigation;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSwitchToHeaderOrSourceRelatedProvider
extends GotoRelatedProvider {
    @NotNull
    public List<? extends GotoRelatedItem> getItems(@NotNull PsiElement context) {
        return Collections.emptyList();
    }

    @NotNull
    public List<? extends GotoRelatedItem> getItems(@NotNull DataContext context) {
        Project project = (Project)context.getData(CommonDataKeys.PROJECT);
        PsiElement element = OCSwitchToHeaderOrSourceRelatedProvider.getContextElement(context);
        if (element == null) {
            return Collections.emptyList();
        }
        ThrowableComputable process2 = () -> (List)ReadAction.compute(() -> OCSwitchToHeaderOrSourceRelatedProvider.doGetItems(element));
        return ContainerUtil.notNullize((List)((List)ProgressManager.getInstance().runProcessWithProgressSynchronously(process2, OCBundle.message("header.source.looking.for.the.best.file", new Object[0]), true, project)));
    }

    @Nullable
    private static PsiElement getContextElement(@NotNull DataContext context) {
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
        if (file != null && editor != null) {
            PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
            if (element != null) {
                return element;
            }
            return file;
        }
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(context);
        return element == null ? file : element;
    }

    @NotNull
    private static List<GotoRelatedItem> doGetItems(@NotNull PsiElement context) {
        PsiFile file = context.getContainingFile();
        OCFile target = file instanceof OCFile ? ((OCFile)file).getAssociatedFile() : null;
        final NavigatablePsiElement counter = OCSwitchToHeaderOrSourceRelatedProvider.findCounterPartInFile(context, target);
        if (counter != null) {
            return Collections.singletonList(new GotoRelatedItem((PsiElement)counter, OCSwitchToHeaderOrSourceRelatedProvider.getGroupCaption(target != null && target.isHeader())){

                public void navigate() {
                    NavigationUtil.activateFileWithPsiElement((PsiElement)counter);
                }
            });
        }
        if (target != null) {
            return Collections.singletonList(new GotoRelatedItem((PsiElement)target, OCSwitchToHeaderOrSourceRelatedProvider.getGroupCaption(target.isHeader())));
        }
        return Collections.emptyList();
    }

    @NotNull
    @NlsContexts.Separator
    private static String getGroupCaption(boolean isHeader) {
        return isHeader ? OCBundle.message("switch.header.source.separator.headers", new Object[0]) : OCBundle.message("switch.header.source.separator.sources", new Object[0]);
    }

    @Nullable
    private static NavigatablePsiElement getCounterPartInFile(PsiElement psi, OCFile file) {
        OCSymbol target;
        if (!(psi instanceof OCSymbolDeclarator) || psi instanceof OCMethodSelectorPart) {
            return null;
        }
        Project project = psi.getProject();
        Object symbol = ((OCSymbolDeclarator)psi).getSymbol();
        OCSymbol oCSymbol = target = symbol != null ? symbol.getAssociatedSymbol(project) : null;
        if (target != null && (file == null || file.equals(target.getContainingOCFile(project)))) {
            return (NavigatablePsiElement)target.locateDefinition(project);
        }
        return null;
    }

    @Nullable
    private static NavigatablePsiElement findCounterPartInFile(PsiElement psi, OCFile file) {
        while (psi != null && !(psi instanceof PsiFile)) {
            NavigatablePsiElement counter = OCSwitchToHeaderOrSourceRelatedProvider.getCounterPartInFile(psi, file);
            if (counter != null) {
                return counter;
            }
            psi = psi.getParent();
        }
        return null;
    }
}

